/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank;

import java.util.Collections;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeType;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeWrapper;

public class TankUpgradeItem
extends UpgradeItemBase<TankUpgradeWrapper> {
    public static final UpgradeType<TankUpgradeWrapper> TYPE = new UpgradeType<TankUpgradeWrapper>(TankUpgradeWrapper::new);

    @Override
    public UpgradeType<TankUpgradeWrapper> getType() {
        return TYPE;
    }

    @Override
    public UpgradeSlotChangeResult canAddUpgradeTo(IBackpackWrapper backpackWrapper, ItemStack upgradeStack, boolean firstLevelBackpack) {
        HashSet<Integer> errorUpgradeSlots = new HashSet<Integer>();
        backpackWrapper.getUpgradeHandler().getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof TankUpgradeWrapper) {
                errorUpgradeSlots.add((Integer)slot);
            }
        });
        if (errorUpgradeSlots.size() >= 2) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.translError("add.two_tank_upgrades_present", new Object[0]), errorUpgradeSlots, Collections.emptySet(), Collections.emptySet());
        }
        int multiplierRequired = (int)Math.ceil((float)TankUpgradeWrapper.getContents(upgradeStack).getAmount() / (float)TankUpgradeWrapper.getTankCapacity(backpackWrapper));
        if (multiplierRequired > 1) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.translError("add.tank_capacity_high", multiplierRequired), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new UpgradeSlotChangeResult.Success();
    }

    @Override
    public int getInventoryColumnsTaken() {
        return 2;
    }
}

