/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter.StonecutterUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class StonecutterUpgradeWrapper
extends UpgradeWrapperBase<StonecutterUpgradeWrapper, StonecutterUpgradeItem> {
    private static final String RECIPE_ID_TAG = "recipeId";
    private final IItemHandlerModifiable inputInventory;

    protected StonecutterUpgradeWrapper(IBackpackWrapper backpackWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.inputInventory = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (slot == 0) {
                    upgrade.func_77983_a("input", (INBT)this.getStackInSlot(0).serializeNBT());
                }
            }
        };
        NBTHelper.getCompound(upgrade, "input").ifPresent(tag -> this.inputInventory.setStackInSlot(0, ItemStack.func_199557_a((CompoundNBT)tag)));
    }

    public IItemHandlerModifiable getInputInventory() {
        return this.inputInventory;
    }

    public void setRecipeId(@Nullable ResourceLocation recipeId) {
        if (recipeId == null) {
            NBTHelper.removeTag(this.upgrade, RECIPE_ID_TAG);
            return;
        }
        this.upgrade.func_77983_a(RECIPE_ID_TAG, (INBT)StringNBT.func_229705_a_((String)recipeId.toString()));
        this.save();
    }

    public Optional<ResourceLocation> getRecipeId() {
        return NBTHelper.getString(this.upgrade, RECIPE_ID_TAG).map(ResourceLocation::new);
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public boolean shouldShiftClickIntoBackpack() {
        return NBTHelper.getBoolean(this.upgrade, "shiftClickIntoBackpack").orElse(true);
    }

    public void setShiftClickIntoBackpack(boolean shiftClickIntoBackpack) {
        NBTHelper.setBoolean(this.upgrade, "shiftClickIntoBackpack", shiftClickIntoBackpack);
        this.save();
    }
}

