/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.BackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.CompositeBackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;

public abstract class FilterLogicControlBase<F extends FilterLogicBase, S extends Slot, C extends FilterLogicContainerBase<F, S>>
extends CompositeBackpackWidget<BackpackWidget> {
    public static final int TAG_FONT_COLOR = 0xF9FFFE;
    public static final int MORE_TAGS_FONT_COLOR = 0xD3D3D3;
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int MAX_TAG_NAME_WIDTH = 68;
    protected final MatchButton[] showMatchButtons;
    protected final int slotsTopYOffset;
    protected final int slotsPerRow;
    protected final int slotsInExtraRow;
    protected final int fullSlotRows;
    private final BackpackScreen screen;
    protected final C container;
    private final int height;
    private final int width;
    private final List<ITextProperties> addTagTooltip = new ArrayList<ITextProperties>();
    private final List<ITextProperties> removeTagTooltip = new ArrayList<ITextProperties>();
    private final List<ITextProperties> tagListTooltip = new ArrayList<ITextProperties>();
    @Nullable
    private ToggleButton<Boolean> nbtButton = null;
    @Nullable
    private ToggleButton<Boolean> durabilityButton = null;
    private int tagButtonsYOffset;

    protected FilterLogicControlBase(BackpackScreen screen, C container, Position position, boolean buttonsVisible, int slotsPerRow, MatchButton ... showMatchButtons) {
        super(position);
        this.screen = screen;
        this.container = container;
        this.slotsTopYOffset = buttonsVisible ? 21 : 0;
        this.slotsPerRow = slotsPerRow;
        this.showMatchButtons = showMatchButtons;
        if (this.shouldShow(MatchButton.ALLOW_LIST)) {
            this.addChild(new ToggleButton<Boolean>(new Position(this.x, this.y), ButtonDefinitions.ALLOW_LIST, button -> container.setAllowList(!container.isAllowList()), () -> container.isAllowList()));
        }
        if (this.shouldShow(MatchButton.PRIMARY_MATCH)) {
            this.addChild(new ToggleButton<PrimaryMatch>(new Position(this.x + 18, this.y), ButtonDefinitions.PRIMARY_MATCH, button -> {
                PrimaryMatch next = container.getPrimaryMatch().next();
                if (next == PrimaryMatch.TAGS) {
                    container.getFilterSlots().forEach(slot -> {
                        slot.field_75223_e = -1000;
                    });
                    this.onTagsMatchSelected();
                }
                container.setPrimaryMatch(next);
                this.setDurabilityAndNbtButtonsVisibility();
                this.moveSlotsToView();
            }, () -> container.getPrimaryMatch()));
            this.addTagButtons();
        }
        if (this.shouldShow(MatchButton.DURABILITY)) {
            this.durabilityButton = new ToggleButton<Boolean>(new Position(this.x + 36, this.y), ButtonDefinitions.MATCH_DURABILITY, button -> container.setMatchDurability(!container.shouldMatchDurability()), () -> container.shouldMatchDurability());
            this.addChild(this.durabilityButton);
        }
        if (this.shouldShow(MatchButton.NBT)) {
            this.nbtButton = new ToggleButton<Boolean>(new Position(this.x + 54, this.y), ButtonDefinitions.MATCH_NBT, button -> container.setMatchNbt(!container.shouldMatchNbt()), () -> container.shouldMatchNbt());
            this.addChild(this.nbtButton);
        }
        this.width = Math.max(slotsPerRow * 18, this.getMaxButtonWidth());
        this.fullSlotRows = ((FilterLogicContainerBase)container).getFilterSlots().size() / slotsPerRow;
        this.slotsInExtraRow = ((FilterLogicContainerBase)container).getFilterSlots().size() % slotsPerRow;
        this.height = (this.fullSlotRows + (this.slotsInExtraRow > 0 ? 1 : 0)) * 18 + this.slotsTopYOffset;
        this.setDurabilityAndNbtButtonsVisibility();
    }

    private void setDurabilityAndNbtButtonsVisibility() {
        boolean visible;
        boolean bl = visible = ((FilterLogicContainerBase)this.container).getPrimaryMatch() != PrimaryMatch.TAGS;
        if (this.nbtButton != null) {
            this.nbtButton.setVisible(visible);
        }
        if (this.durabilityButton != null) {
            this.durabilityButton.setVisible(visible);
        }
    }

    protected void onTagsMatchSelected() {
    }

    private void addTagButtons() {
        this.tagButtonsYOffset = this.slotsTopYOffset + 54;
        this.addChild(new TagButton(new Position(this.x + 36, this.y + this.tagButtonsYOffset), ButtonDefinitions.REMOVE_TAG, button -> {
            ((FilterLogicContainerBase)this.container).removeSelectedTag();
            this.updateTagListAndRemoveTooltips();
            this.updateAddTooltip();
        }, delta -> {
            if (delta < 0.0) {
                ((FilterLogicContainerBase)this.container).selectNextTagToRemove();
                this.updateTagListAndRemoveTooltips();
            } else {
                ((FilterLogicContainerBase)this.container).selectPreviousTagToRemove();
                this.updateTagListAndRemoveTooltips();
            }
        }){

            @Override
            protected List<ITextProperties> getTooltip() {
                return FilterLogicControlBase.this.removeTagTooltip;
            }
        });
        this.updateTagListAndRemoveTooltips();
        this.addChild(new TagButton(new Position(this.x + 18, this.y + this.tagButtonsYOffset), ButtonDefinitions.ADD_TAG, button -> {
            ((FilterLogicContainerBase)this.container).addSelectedTag();
            this.updateAddTooltip();
            this.updateTagListAndRemoveTooltips();
        }, delta -> {
            if (delta < 0.0) {
                ((FilterLogicContainerBase)this.container).selectNextTagToAdd();
                this.updateAddTooltip();
            } else {
                ((FilterLogicContainerBase)this.container).selectPreviousTagToAdd();
                this.updateAddTooltip();
            }
        }){

            @Override
            protected List<ITextProperties> getTooltip() {
                return FilterLogicControlBase.this.addTagTooltip;
            }
        });
        this.updateAddTooltip();
        ((FilterLogicContainerBase)this.container).getTagSelectionSlot().setOnUpdate(this::updateAddTooltip);
        this.addChild(new ToggleButton<Boolean>(new Position(this.x + 54, this.y + this.tagButtonsYOffset), ButtonDefinitions.MATCH_ANY_TAG, button -> ((FilterLogicContainerBase)this.container).setMatchAnyTag(!((FilterLogicContainerBase)this.container).shouldMatchAnyTag()), () -> this.container.shouldMatchAnyTag()){

            @Override
            protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
                if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                    super.renderBg(matrixStack, minecraft, mouseX, mouseY);
                }
            }

            @Override
            protected void renderWidget(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                    super.renderWidget(matrixStack, mouseX, mouseY, partialTicks);
                }
            }

            @Override
            public boolean func_231047_b_(double mouseX, double mouseY) {
                return ((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS && super.func_231047_b_(mouseX, mouseY);
            }
        });
    }

    private void updateTagListAndRemoveTooltips() {
        this.updateTagListTooltip();
        this.updateRemoveTooltip();
    }

    private void updateTagListTooltip() {
        this.tagListTooltip.clear();
        this.tagListTooltip.add((ITextProperties)new TranslationTextComponent(TranslationHelper.translUpgradeKey("tag_list.title")).func_240701_a_(new TextFormatting[0]));
        Set<ResourceLocation> tagNames = ((FilterLogicContainerBase)this.container).getTagNames();
        if (tagNames.isEmpty()) {
            this.tagListTooltip.add((ITextProperties)new TranslationTextComponent(TranslationHelper.translUpgradeKey("tag_list.empty")).func_240699_a_(TextFormatting.DARK_GRAY));
            return;
        }
        for (ResourceLocation tagName : tagNames) {
            this.tagListTooltip.add((ITextProperties)new StringTextComponent("> " + tagName.toString()).func_240699_a_(TextFormatting.GRAY));
        }
    }

    private void updateRemoveTooltip() {
        this.removeTagTooltip.clear();
        this.removeTagTooltip.add((ITextProperties)new TranslationTextComponent(TranslationHelper.translUpgradeButton("remove_tag")));
        Set<ResourceLocation> tagNames = ((FilterLogicContainerBase)this.container).getTagNames();
        if (tagNames.isEmpty()) {
            this.removeTagTooltip.add((ITextProperties)new TranslationTextComponent(TranslationHelper.translUpgradeButton("remove_tag.empty")).func_240699_a_(TextFormatting.RED));
            return;
        }
        int curIndex = 0;
        for (ResourceLocation tagName : tagNames) {
            if (curIndex == ((FilterLogicContainerBase)this.container).getSelectedTagToRemove()) {
                this.removeTagTooltip.add((ITextProperties)new StringTextComponent("-> " + tagName.toString()).func_240699_a_(TextFormatting.RED));
            } else {
                this.removeTagTooltip.add((ITextProperties)new StringTextComponent("> " + tagName.toString()).func_240699_a_(TextFormatting.GRAY));
            }
            ++curIndex;
        }
        this.removeTagTooltip.add((ITextProperties)new TranslationTextComponent(TranslationHelper.translUpgradeButton("remove_tag.controls")).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.DARK_GRAY}));
    }

    private void updateAddTooltip() {
        this.addTagTooltip.clear();
        this.addTagTooltip.add((ITextProperties)new TranslationTextComponent(TranslationHelper.translUpgradeButton("add_tag")));
        if (((FilterLogicContainerBase)this.container).getTagSelectionSlot().func_75211_c().func_190926_b()) {
            this.addTagTooltip.add((ITextProperties)new TranslationTextComponent(TranslationHelper.translUpgradeButton("add_tag.no_item")).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.DARK_GRAY}));
            return;
        }
        Set<ResourceLocation> tagsToAdd = ((FilterLogicContainerBase)this.container).getTagsToAdd();
        int curIndex = 0;
        for (ResourceLocation tagName : tagsToAdd) {
            if (curIndex == ((FilterLogicContainerBase)this.container).getSelectedTagToAdd()) {
                this.addTagTooltip.add((ITextProperties)new StringTextComponent("-> " + tagName.toString()).func_240699_a_(TextFormatting.GREEN));
            } else {
                this.addTagTooltip.add((ITextProperties)new StringTextComponent("> " + tagName.toString()).func_240699_a_(TextFormatting.GRAY));
            }
            ++curIndex;
        }
        if (tagsToAdd.isEmpty()) {
            this.addTagTooltip.add((ITextProperties)new TranslationTextComponent(TranslationHelper.translUpgradeButton("add_tag.no_additional_tags")).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.YELLOW}));
        } else {
            this.addTagTooltip.add((ITextProperties)new TranslationTextComponent(TranslationHelper.translUpgradeButton("add_tag.controls")).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.DARK_GRAY}));
        }
    }

    protected int getMaxButtonWidth() {
        int maxWidth = 0;
        for (BackpackWidget w : this.children) {
            int buttonWidth = w.getX() + w.getWidth() - this.x;
            if (buttonWidth <= maxWidth) continue;
            maxWidth = buttonWidth;
        }
        return maxWidth;
    }

    protected boolean shouldShow(MatchButton matchButton) {
        for (MatchButton showMatchButton : this.showMatchButtons) {
            if (showMatchButton != matchButton) continue;
            return true;
        }
        return false;
    }

    public void moveSlotsToView() {
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
            FilterLogicContainerBase.TagSelectionSlot slot = ((FilterLogicContainerBase)this.container).getTagSelectionSlot();
            slot.field_75223_e = this.x - this.screen.getGuiLeft() + 1;
            slot.field_75221_f = this.y - this.screen.getGuiTop() + this.tagButtonsYOffset + 1;
            ((FilterLogicContainerBase)this.container).getFilterSlots().forEach(s -> {
                s.field_75223_e = -1000;
            });
        } else {
            int upgradeSlotNumber = 0;
            for (Slot slot : ((FilterLogicContainerBase)this.container).getFilterSlots()) {
                slot.field_75223_e = this.x - this.screen.getGuiLeft() + 1 + upgradeSlotNumber % this.slotsPerRow * 18;
                slot.field_75221_f = this.y - this.screen.getGuiTop() + this.slotsTopYOffset + 1 + upgradeSlotNumber / this.slotsPerRow * 18;
                ++upgradeSlotNumber;
            }
            ((FilterLogicContainerBase)this.container).getTagSelectionSlot().field_75223_e = -1000;
        }
    }

    @Override
    protected void renderWidget(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(matrixStack, mouseX, mouseY, partialTicks);
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
            int count = 0;
            int prefixWidth = this.font.func_78256_a("...");
            Set<ResourceLocation> tagNames = ((FilterLogicContainerBase)this.container).getTagNames();
            for (ResourceLocation tagName : tagNames) {
                String name;
                String shortened = name = tagName.toString();
                if (this.font.func_78256_a(name) > 68 && !(shortened = this.font.func_238413_a_(name, 68 - prefixWidth, true)).equals(name)) {
                    shortened = "..." + shortened;
                }
                this.font.func_238421_b_(matrixStack, shortened, (float)this.x + 2.0f, (float)this.y + 23.0f + (float)(count * 10), 0xF9FFFE);
                if (tagNames.size() <= 5 || ++count != 4) continue;
                this.font.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent(TranslationHelper.translUpgradeKey("tag_list.tag_overflow"), new Object[]{String.valueOf(tagNames.size() - 4)}), (float)this.x + 2.0f, (float)this.y + 23.0f + (float)(count * 10), 0xD3D3D3);
                break;
            }
            if (this.isMouseOverTagList(mouseX, mouseY)) {
                GuiHelper.setTooltipToRender(this.tagListTooltip);
            }
        }
    }

    private boolean isMouseOverTagList(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + 72) && mouseY >= (double)(this.y + this.slotsTopYOffset) && mouseY < (double)(this.y + this.slotsTopYOffset + 54);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() != PrimaryMatch.TAGS) {
            GuiHelper.renderSlotsBackground(minecraft, matrixStack, this.x, this.y + this.slotsTopYOffset, this.slotsPerRow, this.fullSlotRows, this.slotsInExtraRow);
        } else {
            GuiHelper.renderSlotsBackground(minecraft, matrixStack, this.x, this.y + this.tagButtonsYOffset, 1, 1, 0);
            this.renderTagListBackground(matrixStack, minecraft);
        }
    }

    private void renderTagListBackground(MatrixStack matrixStack, Minecraft minecraft) {
        minecraft.func_110434_K().func_110577_a(GuiHelper.GUI_CONTROLS);
        int u = 29;
        int v = 146;
        int renderWidth = 72;
        int renderHeight = 54;
        int textureBgWidth = 66;
        int textureBgHeight = 56;
        int halfWidth = renderWidth / 2;
        int halfHeight = renderHeight / 2;
        FilterLogicControlBase.func_238463_a_((MatrixStack)matrixStack, (int)this.x, (int)(this.y + this.slotsTopYOffset), (float)u, (float)v, (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        FilterLogicControlBase.func_238463_a_((MatrixStack)matrixStack, (int)this.x, (int)(this.y + this.slotsTopYOffset + halfHeight), (float)u, (float)((float)v + (float)textureBgHeight - (float)halfHeight), (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        FilterLogicControlBase.func_238463_a_((MatrixStack)matrixStack, (int)(this.x + halfWidth), (int)(this.y + this.slotsTopYOffset), (float)((float)u + (float)textureBgWidth - (float)halfWidth), (float)v, (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        FilterLogicControlBase.func_238463_a_((MatrixStack)matrixStack, (int)(this.x + halfWidth), (int)(this.y + this.slotsTopYOffset + halfHeight), (float)((float)u + (float)textureBgWidth - (float)halfWidth), (float)((float)v + (float)textureBgHeight - (float)halfHeight), (int)halfWidth, (int)halfHeight, (int)256, (int)256);
    }

    public static enum MatchButton {
        ALLOW_LIST,
        PRIMARY_MATCH,
        DURABILITY,
        NBT;

    }

    private class TagButton
    extends Button {
        private final DoubleConsumer onScroll;

        public TagButton(Position position, ButtonDefinition buttonDefinition, IntConsumer onClick, DoubleConsumer onScroll) {
            super(position, buttonDefinition, onClick);
            this.onScroll = onScroll;
        }

        @Override
        protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
            if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                super.renderBg(matrixStack, minecraft, mouseX, mouseY);
            }
        }

        @Override
        protected void renderWidget(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                super.renderWidget(matrixStack, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public boolean func_231047_b_(double mouseX, double mouseY) {
            return ((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS && super.func_231047_b_(mouseX, mouseY);
        }

        public boolean func_231043_a_(double pMouseX, double pMouseY, double pDelta) {
            if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() != PrimaryMatch.TAGS) {
                return false;
            }
            this.onScroll.accept(pDelta);
            return true;
        }
    }
}

