/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.container.Slot;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SettingsTabControl;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.BackToBackpackTab;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.SettingsTab;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsTab;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.nosort.NoSortSettingsTab;

public class BackpackSettingsTabControl
extends SettingsTabControl<SettingsScreen, SettingsTab<?>> {
    private static final Map<String, ISettingsTabFactory<?, ?>> SETTINGS_TAB_FACTORIES;
    private final List<SettingsTab<?>> settingsTabs = new ArrayList();

    public BackpackSettingsTabControl(SettingsScreen screen, Position position) {
        super(position);
        this.addChild(new BackToBackpackTab(new Position(this.x, this.getTopY())));
        ((SettingsContainer)screen.func_212873_a_()).forEachSettingsContainer((categoryName, settingsContainer) -> this.settingsTabs.add(this.addSettingsTab(() -> {}, () -> {}, BackpackSettingsTabControl.instantiateContainer(categoryName, settingsContainer, new Position(this.x, this.getTopY()), screen))));
    }

    private static <C extends SettingsContainerBase<?>, T extends SettingsTab<C>> void addFactory(ImmutableMap.Builder<String, ISettingsTabFactory<?, ?>> builder, String categoryName, ISettingsTabFactory<C, T> factory) {
        builder.put((Object)categoryName, factory);
    }

    public void renderSlotOverlays(MatrixStack matrixStack, Slot slot, ISlotOverlayRenderer overlayRenderer) {
        ArrayList colors = new ArrayList();
        this.settingsTabs.forEach(tab -> tab.getSlotOverlayColor(slot.field_75222_d).ifPresent(colors::add));
        colors.forEach(c -> overlayRenderer.renderSlotOverlay(matrixStack, slot, (int)c));
    }

    public void handleSlotClick(Slot slot, int mouseButton) {
        this.getOpenTab().ifPresent(tab -> tab.handleSlotClick(slot, mouseButton));
    }

    private static <C extends SettingsContainerBase<?>> SettingsTab<C> instantiateContainer(String categoryName, C container, Position position, SettingsScreen screen) {
        return BackpackSettingsTabControl.getSettingsTabFactory(categoryName).create(container, position, screen);
    }

    private static <C extends SettingsContainerBase<?>, T extends SettingsTab<C>> ISettingsTabFactory<C, T> getSettingsTabFactory(String name) {
        return SETTINGS_TAB_FACTORIES.get(name);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        BackpackSettingsTabControl.addFactory(builder, "backpack", BackpackSettingsTab::new);
        BackpackSettingsTabControl.addFactory(builder, "no_sort", NoSortSettingsTab::new);
        SETTINGS_TAB_FACTORIES = builder.build();
    }

    public static interface ISettingsTabFactory<C extends SettingsContainerBase<?>, T extends SettingsTab<C>> {
        public T create(C var1, Position var2, SettingsScreen var3);
    }

    public static interface ISlotOverlayRenderer {
        public void renderSlotOverlay(MatrixStack var1, Slot var2, int var3);
    }
}

