/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.registry.tool;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.IRegistryDataLoader;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.BlockContext;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.CacheableStackPredicate;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.IMatcherFactory;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ItemMatcherFactory;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.Matchers;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ModMatcher;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ToolTypeMatcher;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RegistryHelper;

public class ToolRegistry {
    public static final Set<String> SWORD_TOOL_TYPES_TO_SKIP = ImmutableSet.of((Object)"cut", (Object)"sword");
    private static final String TOOLS_PROPERTY = "tools";
    private static final Field TOOL_TYPES = ObfuscationReflectionHelper.findField(ToolType.class, (String)"VALUES");
    private static final Set<String> modsWithMapping;
    private static final ToolMapping<Block, BlockContext> BLOCK_TOOL_MAPPING;
    private static final ToolMapping<EntityType<?>, Entity> ENTITY_TOOL_MAPPING;
    private static final ToolTypeMapping TOOL_TYPE_MAPPING;

    private ToolRegistry() {
    }

    public static Map<String, ToolType> getToolTypes() {
        try {
            HashMap<String, ToolType> toolTypes = new HashMap<String, ToolType>();
            ((Map)TOOL_TYPES.get(null)).forEach((key, value) -> {
                if (!SWORD_TOOL_TYPES_TO_SKIP.contains(key)) {
                    toolTypes.put((String)key, (ToolType)value);
                }
            });
            return toolTypes;
        }
        catch (IllegalAccessException e) {
            return Collections.emptyMap();
        }
    }

    public static boolean isToolForBlock(ItemStack stack, Block block, World world, BlockState blockState, BlockPos pos) {
        return BLOCK_TOOL_MAPPING.isToolFor(stack, block, () -> new BlockContext(world, blockState, block, pos));
    }

    public static boolean isToolForEntity(ItemStack stack, Entity entity) {
        return ENTITY_TOOL_MAPPING.isToolFor(stack, entity.func_200600_R(), () -> entity);
    }

    public static Set<ToolType> getItemToolTypes(ItemStack stack) {
        return TOOL_TYPE_MAPPING.getItemToolTypes(stack);
    }

    protected static Tuple<Set<Item>, Set<CacheableStackPredicate>> getItemsAndItemPredicates(Map.Entry<String, JsonElement> property) {
        if (property.getValue().isJsonArray()) {
            JsonArray toolArray = JSONUtils.func_151207_m((JsonElement)property.getValue(), (String)"");
            return ToolRegistry.getItemsAndItemPredicates(toolArray);
        }
        SophisticatedBackpacks.LOGGER.error("Invalid tools list - needs to be an array {}", (Object)property.getValue());
        return new Tuple(Collections.emptySet(), Collections.emptySet());
    }

    protected static Tuple<Set<Item>, Set<CacheableStackPredicate>> getItemsAndItemPredicates(JsonArray toolArray) {
        HashSet<Item> items = new HashSet<Item>();
        HashSet itemPredicates = new HashSet();
        for (JsonElement jsonElement : toolArray) {
            if (jsonElement.isJsonPrimitive()) {
                ResourceLocation itemName = new ResourceLocation(jsonElement.getAsString());
                if (!ForgeRegistries.ITEMS.containsKey(itemName)) {
                    SophisticatedBackpacks.LOGGER.debug("{} isn't loaded in item registry, skipping ...", (Object)itemName);
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemName);
                items.add(item);
                continue;
            }
            if (!jsonElement.isJsonObject()) continue;
            Matchers.getItemMatcher(jsonElement).ifPresent(itemPredicates::add);
        }
        return new Tuple(items, itemPredicates);
    }

    public static void addModWithMapping(String modId) {
        modsWithMapping.add(modId);
    }

    static {
        Matchers.addItemMatcherFactory(new ItemMatcherFactory("tool"){

            @Override
            protected Optional<CacheableStackPredicate> getPredicateFromObject(JsonObject jsonObject) {
                String toolName = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tool");
                return Optional.of(new ToolTypeMatcher(ToolType.get((String)toolName)));
            }
        });
        modsWithMapping = new HashSet<String>();
        BLOCK_TOOL_MAPPING = new ToolMapping<Block, BlockContext>(BlockContext::getBlock);
        ENTITY_TOOL_MAPPING = new ToolMapping<EntityType, Entity>(Entity::func_200600_R);
        TOOL_TYPE_MAPPING = new ToolTypeMapping();
    }

    private static class ToolMapping<T extends ForgeRegistryEntry<?>, C> {
        private final Function<C, T> getObjectFromContext;
        private final Map<T, Set<Item>> notToolCache = new HashMap<T, Set<Item>>();
        private final Map<T, Set<Item>> objectTools = new HashMap<T, Set<Item>>();
        private final Map<T, Set<CacheableStackPredicate>> objectToolPredicates = new HashMap<T, Set<CacheableStackPredicate>>();
        private final Map<Predicate<C>, Set<Item>> objectPredicateTools = new HashMap<Predicate<C>, Set<Item>>();
        private final Map<Predicate<C>, Set<CacheableStackPredicate>> objectPredicateToolPredicates = new HashMap<Predicate<C>, Set<CacheableStackPredicate>>();

        public ToolMapping(Function<C, T> getObjectFromContext) {
            this.getObjectFromContext = getObjectFromContext;
        }

        private void addObjectPredicateTools(Tuple<Set<Item>, Set<CacheableStackPredicate>> tools, Predicate<C> predicate) {
            ((Set)tools.func_76341_a()).forEach(t -> this.objectPredicateTools.computeIfAbsent(predicate, p -> new HashSet()).add(t));
            ((Set)tools.func_76340_b()).forEach(tp -> this.objectPredicateToolPredicates.computeIfAbsent(predicate, p -> new HashSet()).add(tp));
        }

        private void addObjectTools(Tuple<Set<Item>, Set<CacheableStackPredicate>> tools, T object) {
            ((Set)tools.func_76341_a()).forEach(t -> this.objectTools.computeIfAbsent(object, b -> new HashSet()).add(t));
            ((Set)tools.func_76340_b()).forEach(tp -> this.objectToolPredicates.computeIfAbsent(object, b -> new HashSet()).add(tp));
        }

        public void clear() {
            this.notToolCache.clear();
            this.objectTools.clear();
            this.objectToolPredicates.clear();
            this.objectPredicateTools.clear();
            this.objectPredicateToolPredicates.clear();
        }

        public boolean isToolFor(ItemStack stack, T object, Supplier<C> getContext) {
            Item item = stack.func_77973_b();
            if (this.objectTools.containsKey(object) && this.objectTools.get(object).contains(item)) {
                return true;
            }
            if (this.notToolCache.containsKey(object) && this.notToolCache.get(object).contains(item)) {
                return false;
            }
            AtomicBoolean shouldCache = new AtomicBoolean(true);
            if (this.tryToMatchAgainstObjectToolPredicates(stack, object, shouldCache)) {
                return true;
            }
            C context = getContext.get();
            if (this.tryToMatchAgainstObjectPredicateTools(item, context)) {
                return true;
            }
            if (this.tryToMatchAgainstObjectPredicateToolPredicates(stack, context, shouldCache)) {
                return true;
            }
            if (this.tryToMatchNoMappingMod(stack, object)) {
                return true;
            }
            if (shouldCache.get()) {
                this.notToolCache.computeIfAbsent(object, b -> new HashSet()).add(item);
            }
            return false;
        }

        private boolean tryToMatchNoMappingMod(ItemStack stack, T object) {
            if (this.isNoMappingModAndNonStackableItemFromSameMod(stack, object)) {
                this.addObjectToolMapping(object, stack.func_77973_b());
                return true;
            }
            return false;
        }

        private boolean isNoMappingModAndNonStackableItemFromSameMod(ItemStack stack, T object) {
            return RegistryHelper.getRegistryName(object).map(rn -> !rn.func_110624_b().equals("minecraft") && !modsWithMapping.contains(rn.func_110624_b()) && RegistryHelper.getRegistryName(stack.func_77973_b()).map(itemRegistryName -> itemRegistryName.func_110624_b().equals(rn.func_110624_b())).orElse(false) != false).orElse(false) != false && stack.func_77976_d() == 1;
        }

        private boolean tryToMatchAgainstObjectPredicateToolPredicates(ItemStack stack, C context, AtomicBoolean shouldCache) {
            for (Map.Entry<Predicate<C>, Set<CacheableStackPredicate>> entry : this.objectPredicateToolPredicates.entrySet()) {
                if (!entry.getKey().test(context)) continue;
                Set<CacheableStackPredicate> toolPredicates = entry.getValue();
                if (!this.tryToMatchTools(stack, (ForgeRegistryEntry)this.getObjectFromContext.apply(context), shouldCache, toolPredicates)) continue;
                return true;
            }
            return false;
        }

        private boolean tryToMatchAgainstObjectToolPredicates(ItemStack stack, T object, AtomicBoolean shouldCache) {
            if (this.objectToolPredicates.containsKey(object)) {
                Set<CacheableStackPredicate> toolPredicates = this.objectToolPredicates.get(object);
                return this.tryToMatchTools(stack, object, shouldCache, toolPredicates);
            }
            return false;
        }

        private boolean tryToMatchAgainstObjectPredicateTools(Item item, C context) {
            for (Map.Entry<Predicate<C>, Set<Item>> entry : this.objectPredicateTools.entrySet()) {
                if (!entry.getKey().test(context) || !entry.getValue().contains(item)) continue;
                this.addObjectToolMapping((ForgeRegistryEntry)this.getObjectFromContext.apply(context), item);
                return true;
            }
            return false;
        }

        private boolean tryToMatchTools(ItemStack stack, T object, AtomicBoolean shouldCache, Set<CacheableStackPredicate> toolPredicates) {
            for (CacheableStackPredicate itemPredicate : toolPredicates) {
                if (itemPredicate.preventsCaching(stack)) {
                    shouldCache.set(false);
                }
                if (!itemPredicate.test(stack)) continue;
                if (!itemPredicate.preventsCaching(stack)) {
                    this.objectTools.computeIfAbsent(object, b -> new HashSet()).add(stack.func_77973_b());
                }
                return true;
            }
            return false;
        }

        private void addObjectToolMapping(T block, Item item) {
            this.objectTools.computeIfAbsent(block, b -> new HashSet()).add(item);
        }

        public Map<T, Set<Item>> getObjectTools() {
            return this.objectTools;
        }

        public void addModPredicateTools(String modId, Tuple<Set<Item>, Set<CacheableStackPredicate>> tools) {
            this.addObjectPredicateTools(tools, new ModMatcher<T, C>(modId, this.getObjectFromContext));
        }
    }

    public static class EntityToolsLoader
    extends ToolsLoaderBase<EntityType<?>, Entity> {
        public EntityToolsLoader() {
            super(Matchers.getEntityMatcherFactories(), ENTITY_TOOL_MAPPING, rn -> Optional.ofNullable((EntityType)ForgeRegistries.ENTITIES.getValue(rn)), "entity_tools", "entities");
        }
    }

    public static class BlockToolsLoader
    extends ToolsLoaderBase<Block, BlockContext> {
        public BlockToolsLoader() {
            super(Matchers.getBlockMatcherFactories(), BLOCK_TOOL_MAPPING, rn -> Optional.ofNullable((Block)ForgeRegistries.BLOCKS.getValue(rn)), "block_tools", "blocks");
        }
    }

    private static abstract class ToolsLoaderBase<T extends ForgeRegistryEntry<?>, C>
    implements IRegistryDataLoader {
        private final List<IMatcherFactory<C>> objectMatcherFactories;
        private final ToolMapping<T, C> toolMapping;
        private final Function<ResourceLocation, Optional<T>> getObjectFromRegistry;
        private final String name;
        private final String objectJsonArrayName;

        public ToolsLoaderBase(List<IMatcherFactory<C>> objectMatcherFactories, ToolMapping<T, C> toolMapping, Function<ResourceLocation, Optional<T>> getObjectFromRegistry, String name, String objectJsonArrayName) {
            this.objectMatcherFactories = objectMatcherFactories;
            this.toolMapping = toolMapping;
            this.getObjectFromRegistry = getObjectFromRegistry;
            this.name = name;
            this.objectJsonArrayName = objectJsonArrayName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void parse(JsonObject json, @Nullable String modId) {
            JsonArray toolsMap = JSONUtils.func_151214_t((JsonObject)json, (String)this.name);
            for (JsonElement jsonElement : toolsMap) {
                if (!jsonElement.isJsonObject()) continue;
                JsonObject entry = jsonElement.getAsJsonObject();
                this.parseEntry(entry);
            }
            this.toolMapping.getObjectTools().keySet().forEach(object -> RegistryHelper.getRegistryName(object).ifPresent(rn -> modsWithMapping.add(rn.func_110624_b())));
        }

        @Override
        public void clear() {
            this.toolMapping.clear();
            modsWithMapping.clear();
        }

        private void parseEntry(JsonObject entry) {
            if (entry.size() == 1) {
                this.parseFromProperty(entry);
            } else if (entry.size() == 2 && entry.has(this.objectJsonArrayName) && entry.has(ToolRegistry.TOOLS_PROPERTY)) {
                this.parseFromArrays(JSONUtils.func_151214_t((JsonObject)entry, (String)this.objectJsonArrayName), JSONUtils.func_151214_t((JsonObject)entry, (String)ToolRegistry.TOOLS_PROPERTY));
            } else {
                SophisticatedBackpacks.LOGGER.error("Invalid block tools entry - needs to have either 1 array property with mod/entity name or \"{}\" and \"tools\" array properties {}", (Object)this.objectJsonArrayName, (Object)entry);
            }
        }

        private void parseFromArrays(JsonArray blocksArray, JsonArray toolsArray) {
            Tuple<Set<Item>, Set<CacheableStackPredicate>> tools = ToolRegistry.getItemsAndItemPredicates(toolsArray);
            if (((Set)tools.func_76341_a()).isEmpty() && ((Set)tools.func_76340_b()).isEmpty()) {
                return;
            }
            for (JsonElement jsonElement : blocksArray) {
                if (jsonElement.isJsonPrimitive() && jsonElement.getAsString().contains(":")) {
                    this.parseObjectEntry(tools, jsonElement.getAsString());
                    continue;
                }
                this.parseObjectPredicateEntry(tools, jsonElement);
            }
        }

        private void parseObjectPredicateEntry(Tuple<Set<Item>, Set<CacheableStackPredicate>> tools, JsonElement jsonElement) {
            for (IMatcherFactory<C> blockMatcherFactory : this.objectMatcherFactories) {
                if (!blockMatcherFactory.appliesTo(jsonElement)) continue;
                blockMatcherFactory.getPredicate(jsonElement).ifPresent(predicate -> ((ToolMapping)this.toolMapping).addObjectPredicateTools((Tuple<Set<Item>, Set<CacheableStackPredicate>>)tools, predicate));
                break;
            }
        }

        private void parseObjectEntry(Tuple<Set<Item>, Set<CacheableStackPredicate>> tools, String objectName) {
            ResourceLocation registryName = new ResourceLocation(objectName);
            Optional<T> objectOptional = this.getObjectFromRegistry.apply(registryName);
            if (objectOptional.isPresent()) {
                ((ToolMapping)this.toolMapping).addObjectTools((Tuple<Set<Item>, Set<CacheableStackPredicate>>)tools, (ForgeRegistryEntry)objectOptional.get());
            } else {
                SophisticatedBackpacks.LOGGER.debug("{} doesn't exist in registry, skipping ...", (Object)objectName);
            }
        }

        private void parseFromProperty(JsonObject entry) {
            for (Map.Entry property : entry.entrySet()) {
                if (((String)property.getKey()).contains(":")) {
                    this.parseObjectTools(property);
                    continue;
                }
                this.parseModTools(property);
            }
        }

        private void parseModTools(Map.Entry<String, JsonElement> property) {
            String modId = property.getKey();
            if (!ModList.get().isLoaded(modId)) {
                SophisticatedBackpacks.LOGGER.debug("{} mod isn't loaded, skipping ... {} ", (Object)modId, property);
                return;
            }
            Tuple<Set<Item>, Set<CacheableStackPredicate>> tools = ToolRegistry.getItemsAndItemPredicates(property);
            if (((Set)tools.func_76341_a()).isEmpty() && ((Set)tools.func_76340_b()).isEmpty()) {
                return;
            }
            this.toolMapping.addModPredicateTools(modId, tools);
        }

        private void parseObjectTools(Map.Entry<String, JsonElement> property) {
            Tuple<Set<Item>, Set<CacheableStackPredicate>> tools = ToolRegistry.getItemsAndItemPredicates(property);
            if (((Set)tools.func_76341_a()).isEmpty() && ((Set)tools.func_76340_b()).isEmpty()) {
                return;
            }
            this.parseObjectEntry(tools, property.getKey());
        }
    }

    public static class ToolTypesLoader
    implements IRegistryDataLoader {
        @Override
        public String getName() {
            return "tool_types";
        }

        @Override
        public void parse(JsonObject json, @Nullable String modId) {
            JsonArray typeTools = json.getAsJsonArray("tool_types");
            for (JsonElement jsonElement : typeTools) {
                if (!jsonElement.isJsonObject()) continue;
                JsonObject entry = jsonElement.getAsJsonObject();
                this.parseEntry(entry);
            }
        }

        private void parseEntry(JsonObject entry) {
            if (entry.size() == 1) {
                this.parseFromProperty(entry);
            } else if (entry.size() == 2 && entry.has(ToolRegistry.TOOLS_PROPERTY) && entry.has("types")) {
                this.parseFromArrays(JSONUtils.func_151214_t((JsonObject)entry, (String)ToolRegistry.TOOLS_PROPERTY), JSONUtils.func_151214_t((JsonObject)entry, (String)"types"));
            } else {
                SophisticatedBackpacks.LOGGER.error("Invalid tool types entry - needs to have either 1 array property with item name or \"tools\" and \"types\" array properties {}", (Object)entry);
            }
        }

        private void parseFromArrays(JsonArray tools, JsonArray types) {
            Set<ToolType> toolTypes = this.getToolTypes(types);
            for (JsonElement toolElement : tools) {
                if (toolElement.isJsonPrimitive()) {
                    this.parseTool(toolElement.getAsString(), toolTypes);
                    continue;
                }
                Matchers.getItemMatcher(toolElement).ifPresent(toolMatcher -> TOOL_TYPE_MAPPING.predicateToolTypes.computeIfAbsent(toolMatcher, p -> new HashSet()).addAll(toolTypes));
            }
        }

        private void parseFromProperty(JsonObject entry) {
            for (Map.Entry property : entry.entrySet()) {
                String toolName = (String)property.getKey();
                Set<ToolType> toolTypes = this.getToolTypes(((JsonElement)property.getValue()).getAsJsonArray());
                this.parseTool(toolName, toolTypes);
            }
        }

        private void parseTool(String toolName, Set<ToolType> toolTypes) {
            Item tool = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(toolName));
            if (tool != null) {
                TOOL_TYPE_MAPPING.toolTypes.computeIfAbsent(tool, t -> new HashSet()).addAll(toolTypes);
            } else {
                String modId = toolName.split(":")[0];
                if (!ModList.get().isLoaded(modId)) {
                    SophisticatedBackpacks.LOGGER.debug("Mod {} isn't loaded skipping load of tool types for {}", (Object)modId, (Object)toolName);
                } else {
                    SophisticatedBackpacks.LOGGER.warn("Mod {} is loaded and yet tool {} doesn't exist in registry, skipping load of tool types for it", (Object)modId, (Object)toolName);
                }
            }
        }

        private Set<ToolType> getToolTypes(JsonArray types) {
            HashSet<ToolType> toolTypes = new HashSet<ToolType>();
            types.forEach(e -> {
                String toolTypeString = e.getAsString();
                toolTypes.add(ToolType.get((String)toolTypeString));
            });
            return toolTypes;
        }

        @Override
        public void clear() {
            TOOL_TYPE_MAPPING.clear();
        }
    }

    private static class ToolTypeMapping {
        private final Map<Item, Set<ToolType>> toolTypes = new HashMap<Item, Set<ToolType>>();
        private final Map<Predicate<ItemStack>, Set<ToolType>> predicateToolTypes = new HashMap<Predicate<ItemStack>, Set<ToolType>>();
        private final Set<Item> notAToolCache = new HashSet<Item>();

        private ToolTypeMapping() {
        }

        public void clear() {
            this.toolTypes.clear();
            this.predicateToolTypes.clear();
        }

        public Set<ToolType> getItemToolTypes(ItemStack stack) {
            if (this.notAToolCache.contains(stack.func_77973_b())) {
                return Collections.emptySet();
            }
            if (this.toolTypes.containsKey(stack.func_77973_b())) {
                return this.toolTypes.get(stack.func_77973_b());
            }
            for (Map.Entry<Predicate<ItemStack>, Set<ToolType>> entry : this.predicateToolTypes.entrySet()) {
                if (!entry.getKey().test(stack)) continue;
                return entry.getValue();
            }
            this.notAToolCache.add(stack.func_77973_b());
            return Collections.emptySet();
        }
    }
}

