/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IIOFilterUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.FilteredItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;

public class InventoryIOHandler {
    private final IItemHandlerModifiable filteredItemHandler;

    public InventoryIOHandler(IBackpackWrapper backpackWrapper) {
        ArrayList<FilterLogic> inputFilters = new ArrayList<FilterLogic>();
        ArrayList<FilterLogic> outputFilters = new ArrayList<FilterLogic>();
        this.addFilters(backpackWrapper, inputFilters, outputFilters);
        IItemHandlerModifiable modifiedInventory = backpackWrapper.getInventoryForUpgradeProcessing();
        this.filteredItemHandler = inputFilters.isEmpty() && outputFilters.isEmpty() ? modifiedInventory : new FilteredItemHandler.Modifiable(modifiedInventory, (List<FilterLogic>)inputFilters, (List<FilterLogic>)outputFilters);
    }

    public IItemHandlerModifiable getFilteredItemHandler() {
        return this.filteredItemHandler;
    }

    private void addFilters(IBackpackWrapper backpackWrapper, List<FilterLogic> inputFilters, List<FilterLogic> outputFilters) {
        List<IIOFilterUpgrade> filterWrappers = backpackWrapper.getUpgradeHandler().getWrappersThatImplement(IIOFilterUpgrade.class);
        for (IIOFilterUpgrade wrapper : filterWrappers) {
            wrapper.getInputFilter().ifPresent(inputFilters::add);
            wrapper.getOutputFilter().ifPresent(outputFilters::add);
        }
    }
}

