/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class BackpackInventoryHandler
extends ItemStackHandler {
    public static final String INVENTORY_TAG = "inventory";
    private static final String REAL_COUNT_TAG = "realCount";
    private final IBackpackWrapper backpackWrapper;
    private final CompoundNBT contentsNbt;
    private final Runnable backpackSaveHandler;
    private final List<IntConsumer> onContentsChangedListeners = new ArrayList<IntConsumer>();
    private boolean persistent = true;
    private final Map<Integer, CompoundNBT> stackNbts = new LinkedHashMap<Integer, CompoundNBT>();
    private int slotLimit;
    private int maxStackSizeMultiplier;

    public BackpackInventoryHandler(int numberOfInventorySlots, IBackpackWrapper backpackWrapper, CompoundNBT contentsNbt, Runnable backpackSaveHandler, int slotLimit) {
        super(numberOfInventorySlots);
        this.backpackWrapper = backpackWrapper;
        this.contentsNbt = contentsNbt;
        this.backpackSaveHandler = backpackSaveHandler;
        this.deserializeNBT(contentsNbt.func_74775_l(INVENTORY_TAG));
        this.initStackNbts();
        this.setSlotLimit(slotLimit);
    }

    public void setSize(int size) {
        super.setSize(this.stacks.size());
    }

    private void initStackNbts() {
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            ItemStack slotStack = (ItemStack)this.stacks.get(slot);
            if (slotStack.func_190926_b()) continue;
            this.stackNbts.put(slot, this.getSlotsStackNbt(slot, slotStack));
        }
    }

    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.persistent && this.updateSlotNbt(slot)) {
            this.saveInventory();
            this.onContentsChangedListeners.forEach(l -> l.accept(slot));
        }
    }

    private boolean updateSlotNbt(int slot) {
        ItemStack slotStack = this.getStackInSlot(slot);
        if (slotStack.func_190926_b()) {
            if (this.stackNbts.containsKey(slot)) {
                this.stackNbts.remove(slot);
                return true;
            }
        } else {
            CompoundNBT itemTag = this.getSlotsStackNbt(slot, slotStack);
            if (!this.stackNbts.containsKey(slot) || !this.stackNbts.get(slot).equals((Object)itemTag)) {
                this.stackNbts.put(slot, itemTag);
                return true;
            }
        }
        return false;
    }

    private CompoundNBT getSlotsStackNbt(int slot, ItemStack slotStack) {
        CompoundNBT itemTag = new CompoundNBT();
        itemTag.func_74768_a("Slot", slot);
        itemTag.func_74768_a(REAL_COUNT_TAG, slotStack.func_190916_E());
        slotStack.func_77955_b(itemTag);
        return itemTag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack slotStack = ItemStack.func_199557_a((CompoundNBT)itemTags);
            if (itemTags.func_74764_b(REAL_COUNT_TAG)) {
                slotStack.func_190920_e(itemTags.func_74762_e(REAL_COUNT_TAG));
            }
            this.stacks.set(slot, (Object)slotStack);
        }
        this.onLoad();
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit;
    }

    public int getStackLimit(int slot, ItemStack stack) {
        int adjustedMaxStackSizeMultiplier = this.maxStackSizeMultiplier > 1 && Config.COMMON.stackUpgrade.canItemStack(stack.func_77973_b()) ? this.maxStackSizeMultiplier : 1;
        return Math.min(this.slotLimit, stack.func_77976_d() * adjustedMaxStackSizeMultiplier);
    }

    public void setSlotLimit(int slotLimit) {
        this.slotLimit = slotLimit;
        this.maxStackSizeMultiplier = slotLimit / 64;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (existing.func_190916_E() <= amount) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - amount)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)amount);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return !(stack.func_77973_b() instanceof BackpackItem) || this.hasInceptionUpgrade() && this.isBackpackWithoutInceptionUpgrade(stack);
    }

    private boolean hasInceptionUpgrade() {
        return this.backpackWrapper.getUpgradeHandler().hasUpgrade(InceptionUpgradeItem.TYPE);
    }

    private boolean isBackpackWithoutInceptionUpgrade(ItemStack stack) {
        return stack.func_77973_b() instanceof BackpackItem && stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(w -> w.getUpgradeHandler().hasUpgrade(InceptionUpgradeItem.TYPE)).orElse(false) == false;
    }

    public void saveInventory() {
        this.contentsNbt.func_218657_a(INVENTORY_TAG, (INBT)this.serializeNBT());
        this.backpackSaveHandler.run();
    }

    public void copyStacksTo(BackpackInventoryHandler otherHandler) {
        InventoryHelper.copyTo((IItemHandlerModifiable)this, (IItemHandlerModifiable)otherHandler);
    }

    public void addListener(IntConsumer onContentsChanged) {
        this.onContentsChangedListeners.add(onContentsChanged);
    }

    public void clearListeners() {
        this.onContentsChangedListeners.clear();
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        nbtTagList.addAll(this.stackNbts.values());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.getSlots());
        return nbt;
    }

    public int getStackSizeMultiplier() {
        return this.maxStackSizeMultiplier;
    }
}

