/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeWrapper;

public class BackpackFluidHandler
implements IFluidHandlerItem {
    private final IBackpackWrapper backpackWrapper;

    public BackpackFluidHandler(IBackpackWrapper backpackWrapper) {
        this.backpackWrapper = backpackWrapper;
    }

    public int getTanks() {
        return this.getAllTanks().size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.isInvalidTank(tank) ? FluidStack.EMPTY : this.getAllTanks().get(tank).getContents();
    }

    @Nonnull
    private List<TankUpgradeWrapper> getAllTanks() {
        return this.backpackWrapper.getUpgradeHandler().getTypeWrappers(TankUpgradeItem.TYPE);
    }

    public int getTankCapacity(int tank) {
        return this.isInvalidTank(tank) ? 0 : this.getAllTanks().get(tank).getTankCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (this.isInvalidTank(tank)) {
            return false;
        }
        FluidStack contents = this.getAllTanks().get(tank).getContents();
        return contents.isEmpty() || contents.getFluid() == stack.getFluid();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int filled = 0;
        FluidStack toFill = resource;
        for (TankUpgradeWrapper tank : this.getAllTanks()) {
            if ((filled += tank.fill(toFill, action)) == resource.getAmount()) {
                return resource.getAmount();
            }
            toFill = new FluidStack(toFill.getFluid(), resource.getAmount() - filled);
        }
        return filled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int drained = 0;
        int toDrain = resource.getAmount();
        for (TankUpgradeWrapper tank : this.getAllTanks()) {
            if ((drained += tank.drain(toDrain, action).getAmount()) == resource.getAmount()) {
                return resource;
            }
            toDrain = resource.getAmount() - drained;
        }
        return drained == 0 ? FluidStack.EMPTY : new FluidStack(resource.getFluid(), drained);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (TankUpgradeWrapper tank : this.getAllTanks()) {
            FluidStack drained = tank.drain(maxDrain, action);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    private boolean isInvalidTank(int tank) {
        return tank < 0 || tank >= this.getTanks();
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.backpackWrapper.getBackpack();
    }
}

