/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class BackpackShapes {
    private static final Map<Integer, VoxelShape> SHAPES = new HashMap<Integer, VoxelShape>();
    private static final VoxelShape BODY = Stream.of(Block.func_208617_a((double)5.25, (double)0.0, (double)4.0, (double)5.75, (double)12.5, (double)5.0), Block.func_208617_a((double)4.25, (double)0.0, (double)4.0, (double)5.25, (double)12.5, (double)5.0), Block.func_208617_a((double)3.75, (double)0.0, (double)4.0, (double)4.25, (double)12.5, (double)5.0), Block.func_208617_a((double)10.25, (double)0.0, (double)4.0, (double)10.75, (double)12.5, (double)5.0), Block.func_208617_a((double)10.75, (double)0.0, (double)4.0, (double)11.75, (double)12.5, (double)5.0), Block.func_208617_a((double)11.75, (double)0.0, (double)4.0, (double)12.25, (double)12.5, (double)5.0), Block.func_208617_a((double)4.25, (double)8.25, (double)11.0, (double)11.75, (double)9.25, (double)11.25), Block.func_208617_a((double)11.75, (double)8.25, (double)5.25, (double)12.75, (double)13.25, (double)11.25), Block.func_208617_a((double)4.25, (double)9.25, (double)5.25, (double)11.75, (double)13.25, (double)11.25), Block.func_208617_a((double)3.25, (double)8.25, (double)5.25, (double)4.25, (double)13.25, (double)11.25), Block.func_208617_a((double)5.75, (double)13.25, (double)7.25, (double)6.5, (double)14.0, (double)8.25), Block.func_208617_a((double)5.75, (double)14.0, (double)7.25, (double)10.25, (double)14.5, (double)8.25), Block.func_208617_a((double)9.5, (double)13.25, (double)7.25, (double)10.25, (double)14.0, (double)8.25), Block.func_208617_a((double)4.5, (double)9.0, (double)4.75, (double)5.5, (double)13.5, (double)11.5), Block.func_208617_a((double)4.5, (double)7.0, (double)10.75, (double)5.5, (double)9.0, (double)11.5), Block.func_208617_a((double)10.5, (double)9.0, (double)4.75, (double)11.5, (double)13.5, (double)11.5), Block.func_208617_a((double)10.5, (double)7.0, (double)10.75, (double)11.5, (double)9.0, (double)11.5), Block.func_208617_a((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)13.0, (double)11.0), Block.func_208617_a((double)4.0, (double)1.0, (double)4.5, (double)12.0, (double)12.0, (double)5.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape BATTERY = Stream.of(Block.func_208617_a((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)6.0, (double)14.0), Block.func_208617_a((double)6.0, (double)5.25, (double)11.5, (double)7.0, (double)6.25, (double)12.5), Block.func_208617_a((double)7.25, (double)5.25, (double)11.5, (double)8.25, (double)6.25, (double)12.5), Block.func_208617_a((double)6.0, (double)7.0, (double)10.25, (double)7.0, (double)8.0, (double)11.25), Block.func_208617_a((double)7.25, (double)7.0, (double)10.25, (double)8.25, (double)8.0, (double)11.25), Block.func_208617_a((double)6.199999999999999, (double)5.6, (double)11.7, (double)6.800000000000001, (double)7.2, (double)12.3), Block.func_208617_a((double)6.199999999999999, (double)7.2, (double)10.7, (double)6.800000000000001, (double)7.8, (double)12.3), Block.func_208617_a((double)7.449999999999999, (double)5.6, (double)11.7, (double)8.05, (double)7.2, (double)12.3), Block.func_208617_a((double)7.449999999999999, (double)7.2, (double)10.7, (double)8.05, (double)7.8, (double)12.3), Block.func_208617_a((double)8.8, (double)4.05, (double)12.95, (double)10.2, (double)5.45, (double)14.35), Block.func_208617_a((double)8.8, (double)0.05, (double)12.95, (double)10.2, (double)1.45, (double)14.35), Block.func_208617_a((double)11.25, (double)4.25, (double)10.25, (double)12.25, (double)5.25, (double)14.25), Block.func_208617_a((double)4.5, (double)4.25, (double)13.25, (double)11.5, (double)5.25, (double)14.25), Block.func_208617_a((double)3.75, (double)4.25, (double)10.25, (double)4.75, (double)5.25, (double)14.25), Block.func_208617_a((double)11.25, (double)0.25, (double)10.25, (double)12.25, (double)1.25, (double)14.25), Block.func_208617_a((double)4.5, (double)0.25, (double)13.25, (double)11.5, (double)1.25, (double)14.25), Block.func_208617_a((double)3.75, (double)0.25, (double)10.25, (double)4.75, (double)1.25, (double)14.25)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape LEFT_TANK = Stream.of(Block.func_208617_a((double)2.5, (double)1.5, (double)6.0, (double)3.5, (double)7.5, (double)10.0), Block.func_208617_a((double)0.5, (double)10.5, (double)6.5, (double)3.5, (double)11.5, (double)9.5), Block.func_208617_a((double)0.0, (double)9.5, (double)6.0, (double)3.0, (double)10.5, (double)10.0), Block.func_208617_a((double)0.0, (double)8.5, (double)6.0, (double)3.0, (double)9.5, (double)10.0), Block.func_208617_a((double)0.0, (double)7.5, (double)6.0, (double)3.0, (double)8.5, (double)10.0), Block.func_208617_a((double)0.0, (double)0.5, (double)6.0, (double)3.0, (double)1.5, (double)10.0), Block.func_208617_a((double)0.5, (double)1.5, (double)6.5, (double)2.5, (double)7.5, (double)9.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape RIGHT_TANK = Stream.of(Block.func_208617_a((double)12.5, (double)1.5, (double)6.0, (double)13.5, (double)7.5, (double)10.0), Block.func_208617_a((double)12.5, (double)10.5, (double)6.5, (double)15.5, (double)11.5, (double)9.5), Block.func_208617_a((double)13.0, (double)9.5, (double)6.0, (double)16.0, (double)10.5, (double)10.0), Block.func_208617_a((double)13.0, (double)8.5, (double)6.0, (double)16.0, (double)9.5, (double)10.0), Block.func_208617_a((double)13.0, (double)7.5, (double)6.0, (double)16.0, (double)8.5, (double)10.0), Block.func_208617_a((double)13.0, (double)0.5, (double)6.0, (double)16.0, (double)1.5, (double)10.0), Block.func_208617_a((double)13.5, (double)1.5, (double)6.5, (double)15.5, (double)7.5, (double)9.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape LEFT_POUCHES = Stream.of(Block.func_208617_a((double)1.0, (double)2.0, (double)5.5, (double)3.0, (double)6.0, (double)10.5), Block.func_208617_a((double)1.0, (double)1.0, (double)5.5, (double)3.0, (double)2.0, (double)10.5), Block.func_208617_a((double)1.0, (double)0.0, (double)5.5, (double)3.0, (double)1.0, (double)10.5), Block.func_208617_a((double)0.75, (double)3.0, (double)7.5, (double)1.0, (double)5.0, (double)8.5), Block.func_208617_a((double)1.0, (double)4.0, (double)5.5, (double)3.0, (double)5.0, (double)10.5), Block.func_208617_a((double)2.0, (double)7.0, (double)5.5, (double)3.0, (double)11.0, (double)10.5), Block.func_208617_a((double)1.75, (double)8.0, (double)7.5, (double)2.0, (double)10.0, (double)8.5), Block.func_208617_a((double)2.0, (double)9.0, (double)5.5, (double)4.0, (double)10.0, (double)10.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape RIGHT_POUCHES = Stream.of(Block.func_208617_a((double)13.0, (double)2.0, (double)5.5, (double)15.0, (double)6.0, (double)10.5), Block.func_208617_a((double)13.0, (double)1.0, (double)5.5, (double)15.0, (double)2.0, (double)10.5), Block.func_208617_a((double)13.0, (double)0.0, (double)5.5, (double)15.0, (double)1.0, (double)10.5), Block.func_208617_a((double)15.0, (double)3.0, (double)7.5, (double)15.25, (double)5.0, (double)8.5), Block.func_208617_a((double)13.0, (double)4.0, (double)5.5, (double)15.0, (double)5.0, (double)10.5), Block.func_208617_a((double)13.0, (double)7.0, (double)5.5, (double)14.0, (double)11.0, (double)10.5), Block.func_208617_a((double)14.0, (double)8.0, (double)7.5, (double)14.25, (double)10.0, (double)8.5), Block.func_208617_a((double)12.0, (double)9.0, (double)5.5, (double)14.0, (double)10.0, (double)10.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape FRONT_POUCH = Stream.of(Block.func_208617_a((double)4.0, (double)2.0, (double)11.0, (double)12.0, (double)6.0, (double)13.0), Block.func_208617_a((double)4.0, (double)1.0, (double)11.0, (double)12.0, (double)2.0, (double)13.0), Block.func_208617_a((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)13.0), Block.func_208617_a((double)5.0, (double)3.0, (double)13.0, (double)6.0, (double)5.0, (double)13.25), Block.func_208617_a((double)10.0, (double)3.0, (double)13.0, (double)11.0, (double)5.0, (double)13.25), Block.func_208617_a((double)4.0, (double)4.0, (double)11.0, (double)12.0, (double)5.0, (double)13.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    private BackpackShapes() {
    }

    public static VoxelShape rotateShape(Direction dir, VoxelShape shape) {
        VoxelShape ret = shape;
        int times = (dir.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            ArrayList shapes = new ArrayList();
            ret.func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> shapes.add(VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX)));
            ret = shapes.stream().reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197880_a());
        }
        return ret;
    }

    public static VoxelShape getShape(Direction dir, boolean leftTank, boolean rightTank, boolean battery) {
        int key = BackpackShapes.getKey(dir, leftTank, rightTank, battery);
        return SHAPES.computeIfAbsent(key, k -> BackpackShapes.composeShape(dir, leftTank, rightTank, battery));
    }

    private static VoxelShape composeShape(Direction dir, boolean leftTank, boolean rightTank, boolean battery) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(BODY);
        shapes.add(leftTank ? LEFT_TANK : LEFT_POUCHES);
        shapes.add(rightTank ? RIGHT_TANK : RIGHT_POUCHES);
        shapes.add(battery ? BATTERY : FRONT_POUCH);
        return BackpackShapes.rotateShape(dir, shapes.stream().reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197880_a()));
    }

    private static int getKey(Direction dir, boolean leftTank, boolean rightTank, boolean battery) {
        return dir.func_176736_b() << 3 | BackpackShapes.b2i(leftTank) << 2 | BackpackShapes.b2i(rightTank) << 1 | BackpackShapes.b2i(battery);
    }

    private static int b2i(boolean value) {
        return value ? 1 : 0;
    }
}

