/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.cmd;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.LoadState;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.lib.LuaLibrary;
import org.squiddev.cobalt.lib.jse.JsePlatform;

public class lua {
    private static final String version = "Luaj 0.0Copyright (c) 2009 Luaj.org.org";
    private static final String usage = "usage: java -cp luaj-jse.jar org.squiddev.cobalt.cmd.lua [options] [script [args]].\nAvailable options are:\n  -e stat  execute string 'stat'\n  -l name  require library 'name'\n  -i       enter interactive mode after executing 'script'\n  -v       show version information\n  -n      \tnodebug - do not load debug library by default\n  --       stop handling options\n  -        execute stdin and stop handling options";
    private static LuaTable _G;

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        boolean interactive = args.length == 0;
        boolean versioninfo = false;
        boolean processing = true;
        ArrayList<String> libs = null;
        try {
            int i;
            int n;
            block14: for (int i2 = 0; i2 < args.length && processing && args[i2].startsWith("-") && args[i2].length() > 1; ++i2) {
                switch (args[i2].charAt(1)) {
                    case 'e': {
                        if (++i2 < args.length) continue block14;
                        lua.usageExit();
                        continue block14;
                    }
                    case 'l': {
                        if (++i2 >= args.length) {
                            lua.usageExit();
                        }
                        if (libs == null) {
                            libs = new ArrayList<String>();
                        }
                        libs.add(args[i2]);
                        continue block14;
                    }
                    case 'i': {
                        interactive = true;
                        continue block14;
                    }
                    case 'v': {
                        versioninfo = true;
                        continue block14;
                    }
                    case '-': {
                        if (args[i2].length() > 2) {
                            lua.usageExit();
                        }
                        processing = false;
                        continue block14;
                    }
                    default: {
                        lua.usageExit();
                    }
                }
            }
            if (versioninfo) {
                System.out.println(version);
            }
            LuaState state = new LuaState();
            _G = JsePlatform.debugGlobals(state);
            int n2 = n = libs != null ? libs.size() : 0;
            for (i = 0; i < n; ++i) {
                lua.loadLibrary(state, (String)libs.get(i));
            }
            processing = true;
            block16: for (i = 0; i < args.length; ++i) {
                if (!processing || !args[i].startsWith("-")) {
                    lua.processScript(state, new FileInputStream(args[i]), args[i], args, i, false);
                    break;
                }
                if ("-".equals(args[i])) {
                    lua.processScript(state, System.in, "=stdin", args, i, false);
                    break;
                }
                switch (args[i].charAt(1)) {
                    case 'l': {
                        ++i;
                        continue block16;
                    }
                    case 'e': {
                        lua.processScript(state, new ByteArrayInputStream(args[++i].getBytes()), "string", args, i, false);
                        continue block16;
                    }
                    case '-': {
                        processing = false;
                    }
                }
            }
            if (interactive) {
                lua.interactiveMode(state);
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            System.exit(-2);
        }
    }

    private static void loadLibrary(LuaState state, String libname) throws IOException {
        LuaString slibname = ValueFactory.valueOf(libname);
        try {
            OperationHelper.noUnwind(state, () -> OperationHelper.call(state, OperationHelper.getTable(state, _G, ValueFactory.valueOf("require")), slibname));
        }
        catch (Exception e) {
            try {
                LuaLibrary v = Class.forName(libname).asSubclass(LuaLibrary.class).newInstance();
                v.add(state, _G);
            }
            catch (Exception f) {
                throw new IOException("loadLibrary(" + libname + ") failed: " + e + "," + f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processScript(LuaState state, InputStream script, String chunkname, String[] args, int firstarg, boolean printValue) throws IOException {
        try {
            LuaFunction c;
            try {
                c = LoadState.load(state, script, ValueFactory.valueOf(chunkname), _G);
            }
            finally {
                script.close();
            }
            LuaValue scriptargs = args != null ? lua.setGlobalArg(args, firstarg) : Constants.NONE;
            Varargs result = LuaThread.runMain(state, c, scriptargs);
            if (printValue && result != Constants.NONE) {
                OperationHelper.noUnwind(state, () -> OperationHelper.invoke(state, OperationHelper.getTable(state, _G, ValueFactory.valueOf("print")), result));
            }
        }
        catch (CompileException e) {
            System.out.println();
            System.out.println(e.getMessage());
        }
        catch (LuaError e) {
            System.out.println();
            System.out.println(e.traceback);
            if (e.getCause() != null && e.getCause() != e) {
                e.getCause().printStackTrace(System.out);
            }
        }
        catch (Exception e) {
            System.out.println();
            e.printStackTrace(System.out);
        }
    }

    private static Varargs setGlobalArg(String[] args, int i) {
        LuaTable arg = ValueFactory.tableOf();
        LuaValue[] values = new LuaValue[args.length];
        for (int j = 0; j < args.length; ++j) {
            values[j] = ValueFactory.valueOf(args[j]);
            arg.rawset(j - i, values[j]);
        }
        _G.rawset("arg", (LuaValue)arg);
        return ValueFactory.varargsOf(values);
    }

    private static void interactiveMode(LuaState state) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("> ");
            System.out.flush();
            String line = reader.readLine();
            if (line == null) {
                return;
            }
            lua.processScript(state, new ByteArrayInputStream(line.getBytes()), "=stdin", null, 0, true);
        }
    }
}

