/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.CachedMetamethod;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaBaseString;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaUserdata;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaFunction;

public abstract class LuaValue
extends Varargs {
    private final int type;

    protected LuaValue(int type) {
        this.type = type;
    }

    public final int type() {
        return this.type;
    }

    public final String typeName() {
        if (this.type >= 0) {
            return Constants.TYPE_NAMES[this.type];
        }
        throw new IllegalStateException("cannot get type of " + this);
    }

    public final boolean isBoolean() {
        return this.type == 1;
    }

    public boolean isClosure() {
        return false;
    }

    public final boolean isFunction() {
        return this.type == 6;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isIntExact() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public final boolean isNil() {
        return this.type == 0;
    }

    public boolean isNumber() {
        return false;
    }

    public final boolean isString() {
        return this.type == 4 || this.type == 3;
    }

    public final boolean isThread() {
        return this.type == 8;
    }

    public final boolean isTable() {
        return this.type == 5;
    }

    public final boolean isUserdata() {
        return this.type == 7;
    }

    public boolean isUserdata(Class<?> c) {
        return false;
    }

    public boolean toBoolean() {
        return true;
    }

    public double toDouble() {
        return Double.NaN;
    }

    public int toInteger() {
        return 0;
    }

    public long toLong() {
        return 0L;
    }

    @Override
    public String toString() {
        return this.typeName() + ": " + Integer.toHexString(this.hashCode());
    }

    public Object toUserdata() {
        return null;
    }

    public <T> T toUserdata(Class<T> c) {
        return null;
    }

    public LuaValue toNumber() {
        return Constants.NIL;
    }

    public LuaValue toLuaString() {
        return Constants.NIL;
    }

    public boolean optBoolean(boolean defval) throws LuaError {
        throw ErrorFactory.argError(this, "boolean");
    }

    public LuaClosure optClosure(LuaClosure defval) throws LuaError {
        throw ErrorFactory.argError(this, "closure");
    }

    public double optDouble(double defval) throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaFunction optFunction(LuaFunction defval) throws LuaError {
        throw ErrorFactory.argError(this, "function");
    }

    public int optInteger(int defval) throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaInteger optLuaInteger(LuaInteger defval) throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public long optLong(long defval) throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaNumber optNumber(LuaNumber defval) throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public String optString(String defval) throws LuaError {
        throw ErrorFactory.argError(this, "string");
    }

    public LuaString optLuaString(LuaString defval) throws LuaError {
        throw ErrorFactory.argError(this, "string");
    }

    public LuaTable optTable(LuaTable defval) throws LuaError {
        throw ErrorFactory.argError(this, "table");
    }

    public LuaThread optThread(LuaThread defval) throws LuaError {
        throw ErrorFactory.argError(this, "thread");
    }

    public Object optUserdata(Object defval) throws LuaError {
        throw ErrorFactory.argError(this, "object");
    }

    public <T> T optUserdata(Class<T> c, T defval) throws LuaError {
        throw ErrorFactory.argError(this, c.getName());
    }

    public LuaValue optValue(LuaValue defval) {
        return this;
    }

    public boolean checkBoolean() throws LuaError {
        throw ErrorFactory.argError(this, "boolean");
    }

    public LuaClosure checkClosure() throws LuaError {
        throw ErrorFactory.argError(this, "closure");
    }

    public double checkArith() throws LuaError {
        throw ErrorFactory.arithError(this);
    }

    public double checkDouble() throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaFunction checkFunction() throws LuaError {
        throw ErrorFactory.argError(this, "function");
    }

    public int checkInteger() throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaInteger checkLuaInteger() throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public long checkLong() throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaNumber checkNumber() throws LuaError {
        throw ErrorFactory.argError(this, "number");
    }

    public LuaNumber checkNumber(String msg) throws LuaError {
        throw new LuaError(msg);
    }

    public String checkString() throws LuaError {
        throw ErrorFactory.argError(this, "string");
    }

    public LuaString checkLuaString() throws LuaError {
        throw ErrorFactory.argError(this, "string");
    }

    public LuaBaseString checkLuaBaseString() throws LuaError {
        return this.checkLuaString();
    }

    public LuaTable checkTable() throws LuaError {
        throw ErrorFactory.argError(this, "table");
    }

    public LuaThread checkThread() throws LuaError {
        throw ErrorFactory.argError(this, "thread");
    }

    public Object checkUserdata() throws LuaError {
        throw ErrorFactory.argError(this, "userdata");
    }

    public <T> T checkUserdata(Class<T> c) throws LuaError {
        throw ErrorFactory.argError(this, "userdata");
    }

    public LuaValue checkNotNil() throws LuaError {
        return this;
    }

    public LuaValue checkValidKey() throws LuaError {
        return this;
    }

    @Override
    public LuaValue arg(int index) {
        return index == 1 ? this : Constants.NIL;
    }

    @Override
    public Varargs asImmutable() {
        return this;
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    public LuaValue first() {
        return this;
    }

    @Override
    public void fill(LuaValue[] array, int offset) {
        array[offset] = this;
    }

    public LuaTable getMetatable(LuaState state) {
        return null;
    }

    public void setMetatable(LuaState state, LuaTable metatable) throws LuaError {
        throw ErrorFactory.argError(this, "table");
    }

    public LuaTable getfenv() throws LuaError {
        throw ErrorFactory.typeError(this, "function or thread");
    }

    public void setfenv(LuaTable env) throws LuaError {
        throw ErrorFactory.typeError(this, "function or thread");
    }

    public LuaValue getn() throws LuaError {
        throw ErrorFactory.unimplemented(this, "getn");
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public boolean raweq(LuaValue val) {
        return this == val;
    }

    public boolean raweq(LuaUserdata val) {
        return false;
    }

    public boolean raweq(LuaString val) {
        return false;
    }

    public boolean raweq(double val) {
        return false;
    }

    public boolean raweq(int val) {
        return false;
    }

    public LuaString strvalue() throws LuaError {
        throw ErrorFactory.typeError(this, "strValue");
    }

    public final LuaValue metatag(LuaState state, LuaValue tag) {
        LuaTable mt = this.getMetatable(state);
        return mt == null ? Constants.NIL : mt.rawget(tag);
    }

    public final LuaValue metatag(LuaState state, CachedMetamethod tag) {
        LuaTable mt = this.getMetatable(state);
        return mt == null ? Constants.NIL : mt.rawget(tag);
    }

    protected static final class PairVarargs
    extends Varargs.DepthVarargs {
        private final LuaValue v1;
        private final Varargs v2;

        public PairVarargs(LuaValue v1, Varargs v2) {
            super(PairVarargs.depth(v2) + 1);
            this.v1 = v1;
            this.v2 = v2;
        }

        @Override
        public LuaValue arg(int i) {
            return i == 1 ? this.v1 : this.v2.arg(i - 1);
        }

        @Override
        public int count() {
            return 1 + this.v2.count();
        }

        @Override
        public LuaValue first() {
            return this.v1;
        }

        @Override
        public Varargs asImmutable() {
            Varargs vClone = this.v2.asImmutable();
            return vClone == this.v2 ? this : new PairVarargs(this.v1, vClone);
        }

        @Override
        public void fill(LuaValue[] array, int offset) {
            array[offset] = this.v1;
            this.v2.fill(array, offset + 1);
        }
    }

    protected static final class ArrayPartVarargs
    extends Varargs.DepthVarargs {
        private Varargs immutable;
        private final int offset;
        private final LuaValue[] v;
        private final int length;
        private final Varargs more;

        public ArrayPartVarargs(LuaValue[] v, int offset, int length) {
            super(1);
            this.v = v;
            this.offset = offset;
            this.length = length;
            this.more = Constants.NONE;
        }

        public ArrayPartVarargs(LuaValue[] v, int offset, int length, Varargs more) {
            super(ArrayPartVarargs.depth(more) + 1);
            this.v = v;
            this.offset = offset;
            this.length = length;
            this.more = more;
        }

        @Override
        public LuaValue arg(int i) {
            return i >= 1 && i <= this.length ? this.v[i + this.offset - 1] : this.more.arg(i - this.length);
        }

        @Override
        public int count() {
            return this.length + this.more.count();
        }

        @Override
        public LuaValue first() {
            return this.length > 0 ? this.v[this.offset] : this.more.first();
        }

        @Override
        public Varargs asImmutable() {
            if (this.immutable != null) {
                return this.immutable;
            }
            LuaValue[] values = new LuaValue[this.length];
            System.arraycopy(this.v, this.offset, values, 0, this.length);
            this.immutable = new ArrayVarargs(values, this.more.asImmutable());
            return this.immutable;
        }

        @Override
        public void fill(LuaValue[] array, int offset) {
            System.arraycopy(this.v, offset, array, offset, this.length);
            this.more.fill(array, offset + this.length);
        }
    }

    protected static final class ArrayVarargs
    extends Varargs.DepthVarargs {
        private final LuaValue[] v;
        private final Varargs r;

        public ArrayVarargs(LuaValue[] v, Varargs r) {
            super(ArrayVarargs.depth(r) + 1);
            this.v = v;
            this.r = r;
        }

        @Override
        public LuaValue arg(int i) {
            return i >= 1 && i <= this.v.length ? this.v[i - 1] : this.r.arg(i - this.v.length);
        }

        @Override
        public int count() {
            return this.v.length + this.r.count();
        }

        @Override
        public LuaValue first() {
            return this.v.length > 0 ? this.v[0] : this.r.first();
        }

        @Override
        public Varargs asImmutable() {
            Varargs rClone = this.r.asImmutable();
            return rClone == this.r ? this : this.r;
        }

        @Override
        public void fill(LuaValue[] array, int offset) {
            System.arraycopy(this.v, 0, array, offset, this.v.length);
            this.r.fill(array, offset + this.v.length);
        }
    }
}

