/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.collect.MapMaker;
import dan200.computercraft.shared.common.TileGeneric;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class TickScheduler {
    private static final Set<TileEntity> toTick = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

    private TickScheduler() {
    }

    public static void schedule(TileGeneric tile) {
        World world = tile.func_145831_w();
        if (world != null && !world.field_72995_K) {
            toTick.add(tile);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Iterator<TileEntity> iterator = toTick.iterator();
        while (iterator.hasNext()) {
            TileEntity tile = iterator.next();
            iterator.remove();
            World world = tile.func_145831_w();
            BlockPos pos = tile.func_174877_v();
            if (world == null || pos == null || !world.isAreaLoaded(pos, 0) || world.func_175625_s(pos) != tile) continue;
            world.func_205220_G_().func_205360_a(pos, (Object)tile.func_195044_w().func_177230_c(), 0);
        }
    }
}

