/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ContinueUploadMessage
extends ComputerServerMessage {
    private final boolean overwrite;

    public ContinueUploadMessage(int instanceId, boolean overwrite) {
        super(instanceId);
        this.overwrite = overwrite;
    }

    public ContinueUploadMessage(@Nonnull PacketBuffer buf) {
        super(buf);
        this.overwrite = buf.readBoolean();
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.overwrite);
    }

    @Override
    protected void handle(NetworkEvent.Context context, @Nonnull ServerComputer computer, @Nonnull IContainerComputer container) {
        ServerPlayerEntity player = context.getSender();
        if (player != null) {
            container.continueUpload(player, this.overwrite);
        }
    }
}

