/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import dan200.computercraft.shared.network.client.ComputerDataClientMessage;
import dan200.computercraft.shared.network.client.ComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.ContinueUploadMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.RequestComputerMessage;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public final class NetworkHandler {
    public static SimpleChannel network;

    private NetworkHandler() {
    }

    public static void setup() {
        String version = ComputerCraftAPI.getInstalledVersion();
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("computercraft", "network")).networkProtocolVersion(() -> version).clientAcceptedVersions(version::equals).serverAcceptedVersions(version::equals).simpleChannel();
        NetworkHandler.registerMainThread(0, NetworkDirection.PLAY_TO_SERVER, ComputerActionServerMessage.class, ComputerActionServerMessage::new);
        NetworkHandler.registerMainThread(1, NetworkDirection.PLAY_TO_SERVER, QueueEventServerMessage.class, QueueEventServerMessage::new);
        NetworkHandler.registerMainThread(2, NetworkDirection.PLAY_TO_SERVER, RequestComputerMessage.class, RequestComputerMessage::new);
        NetworkHandler.registerMainThread(3, NetworkDirection.PLAY_TO_SERVER, KeyEventServerMessage.class, KeyEventServerMessage::new);
        NetworkHandler.registerMainThread(4, NetworkDirection.PLAY_TO_SERVER, MouseEventServerMessage.class, MouseEventServerMessage::new);
        NetworkHandler.registerMainThread(5, NetworkDirection.PLAY_TO_SERVER, UploadFileMessage.class, UploadFileMessage::new);
        NetworkHandler.registerMainThread(6, NetworkDirection.PLAY_TO_SERVER, ContinueUploadMessage.class, ContinueUploadMessage::new);
        NetworkHandler.registerMainThread(10, NetworkDirection.PLAY_TO_CLIENT, ChatTableClientMessage.class, ChatTableClientMessage::new);
        NetworkHandler.registerMainThread(11, NetworkDirection.PLAY_TO_CLIENT, ComputerDataClientMessage.class, ComputerDataClientMessage::new);
        NetworkHandler.registerMainThread(12, NetworkDirection.PLAY_TO_CLIENT, ComputerDeletedClientMessage.class, ComputerDeletedClientMessage::new);
        NetworkHandler.registerMainThread(13, NetworkDirection.PLAY_TO_CLIENT, ComputerTerminalClientMessage.class, ComputerTerminalClientMessage::new);
        NetworkHandler.registerMainThread(14, NetworkDirection.PLAY_TO_CLIENT, PlayRecordClientMessage.class, PlayRecordClientMessage::new);
        NetworkHandler.registerMainThread(15, NetworkDirection.PLAY_TO_CLIENT, MonitorClientMessage.class, MonitorClientMessage::new);
        NetworkHandler.registerMainThread(16, NetworkDirection.PLAY_TO_CLIENT, SpeakerPlayClientMessage.class, SpeakerPlayClientMessage::new);
        NetworkHandler.registerMainThread(17, NetworkDirection.PLAY_TO_CLIENT, SpeakerStopClientMessage.class, SpeakerStopClientMessage::new);
        NetworkHandler.registerMainThread(18, NetworkDirection.PLAY_TO_CLIENT, SpeakerMoveClientMessage.class, SpeakerMoveClientMessage::new);
        NetworkHandler.registerMainThread(19, NetworkDirection.PLAY_TO_CLIENT, UploadResultMessage.class, UploadResultMessage::new);
    }

    public static void sendToPlayer(PlayerEntity player, NetworkMessage packet) {
        network.sendTo((Object)packet, ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAllPlayers(NetworkMessage packet) {
        network.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void sendToServer(NetworkMessage packet) {
        network.sendToServer((Object)packet);
    }

    public static void sendToAllAround(NetworkMessage packet, World world, Vector3d pos, double range) {
        PacketDistributor.TargetPoint target = new PacketDistributor.TargetPoint(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, range, world.func_234923_W_());
        network.send(PacketDistributor.NEAR.with(() -> target), (Object)packet);
    }

    public static void sendToAllTracking(NetworkMessage packet, Chunk chunk) {
        network.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)packet);
    }

    private static <T extends NetworkMessage> void registerMainThread(int id, NetworkDirection direction, Class<T> type, Function<PacketBuffer, T> decoder) {
        network.messageBuilder(type, id, direction).encoder(NetworkMessage::toBytes).decoder(decoder).consumer((packet, contextSup) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSup.get();
            context.enqueueWork(() -> packet.handle(context));
            context.setPacketHandled(true);
        }).add();
    }

    private static <T> Class<T> getType(Supplier<T> supplier) {
        return supplier.get().getClass();
    }
}

