/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;

public final class ComputersArgumentType
implements ArgumentType<ComputersSupplier> {
    private static final ComputersArgumentType MANY = new ComputersArgumentType(false);
    private static final ComputersArgumentType SOME = new ComputersArgumentType(true);
    private static final List<String> EXAMPLES = Arrays.asList("0", "#0", "@Label", "~Advanced");
    private final boolean requireSome;

    public static ComputersArgumentType manyComputers() {
        return MANY;
    }

    public static ComputersArgumentType someComputers() {
        return SOME;
    }

    public static Collection<ServerComputer> getComputersArgument(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return ((ComputersSupplier)context.getArgument(name, ComputersSupplier.class)).unwrap((CommandSource)context.getSource());
    }

    private ComputersArgumentType(boolean requireSome) {
        this.requireSome = requireSome;
    }

    public ComputersSupplier parse(StringReader reader) throws CommandSyntaxException {
        ComputersSupplier computers;
        int start = reader.getCursor();
        char kind = reader.peek();
        if (kind == '@') {
            reader.skip();
            String label = reader.readUnquotedString();
            computers = ComputersArgumentType.getComputers(x -> Objects.equals(label, x.getLabel()));
        } else if (kind == '~') {
            reader.skip();
            String family = reader.readUnquotedString();
            computers = ComputersArgumentType.getComputers(x -> x.getFamily().name().equalsIgnoreCase(family));
        } else if (kind == '#') {
            reader.skip();
            int id = reader.readInt();
            computers = ComputersArgumentType.getComputers(x -> x.getID() == id);
        } else {
            int instance = reader.readInt();
            computers = s -> {
                ServerComputer computer = (ServerComputer)ComputerCraft.serverComputerRegistry.get(instance);
                return computer == null ? Collections.emptyList() : Collections.singletonList(computer);
            };
        }
        if (this.requireSome) {
            String selector = reader.getString().substring(start, reader.getCursor());
            return source -> {
                Collection<ServerComputer> matched = computers.unwrap(source);
                if (matched.isEmpty()) {
                    throw Exceptions.COMPUTER_ARG_NONE.create((Object)selector);
                }
                return matched;
            };
        }
        return computers;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        if (remaining.startsWith("~")) {
            return CommandUtils.suggest(builder, ComputerFamily.values(), x -> "~" + x.name());
        }
        return CommandUtils.suggestOnServer(context, builder, s -> {
            if (remaining.startsWith("@")) {
                ComputersArgumentType.suggestComputers(builder, remaining, x -> {
                    String label = x.getLabel();
                    return label == null ? null : "@" + label;
                });
            } else if (remaining.startsWith("#")) {
                ComputersArgumentType.suggestComputers(builder, remaining, c -> "#" + c.getID());
            } else {
                ComputersArgumentType.suggestComputers(builder, remaining, c -> Integer.toString(c.getInstanceID()));
            }
            return builder.buildFuture();
        });
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static void suggestComputers(SuggestionsBuilder builder, String remaining, Function<ServerComputer, String> renderer) {
        remaining = remaining.toLowerCase(Locale.ROOT);
        for (ServerComputer computer : ComputerCraft.serverComputerRegistry.getComputers()) {
            String converted = renderer.apply(computer);
            if (converted == null || !converted.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
            builder.suggest(converted);
        }
    }

    private static ComputersSupplier getComputers(Predicate<ServerComputer> predicate) {
        return s -> Collections.unmodifiableList(ComputerCraft.serverComputerRegistry.getComputers().stream().filter(predicate).collect(Collectors.toList()));
    }

    public static Set<ServerComputer> unwrap(CommandSource source, Collection<ComputersSupplier> suppliers) throws CommandSyntaxException {
        HashSet<ServerComputer> computers = new HashSet<ServerComputer>();
        for (ComputersSupplier supplier : suppliers) {
            computers.addAll(supplier.unwrap(source));
        }
        return computers;
    }

    @FunctionalInterface
    public static interface ComputersSupplier {
        public Collection<ServerComputer> unwrap(CommandSource var1) throws CommandSyntaxException;
    }

    public static class Serializer
    implements IArgumentSerializer<ComputersArgumentType> {
        public void serializeToNetwork(@Nonnull ComputersArgumentType arg, @Nonnull PacketBuffer buf) {
            buf.writeBoolean(arg.requireSome);
        }

        @Nonnull
        public ComputersArgumentType deserializeFromNetwork(@Nonnull PacketBuffer buf) {
            return buf.readBoolean() ? SOME : MANY;
        }

        public void serializeToJson(@Nonnull ComputersArgumentType arg, @Nonnull JsonObject json) {
            json.addProperty("requireSome", Boolean.valueOf(arg.requireSome));
        }
    }
}

