/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.api.filesystem.IMount;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

public class ComboMount
implements IMount {
    private final IMount[] parts;

    public ComboMount(IMount[] parts) {
        this.parts = parts;
    }

    @Override
    public boolean exists(@Nonnull String path) throws IOException {
        for (int i = this.parts.length - 1; i >= 0; --i) {
            IMount part = this.parts[i];
            if (!part.exists(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirectory(@Nonnull String path) throws IOException {
        for (int i = this.parts.length - 1; i >= 0; --i) {
            IMount part = this.parts[i];
            if (!part.isDirectory(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void list(@Nonnull String path, @Nonnull List<String> contents) throws IOException {
        ArrayList<String> foundFiles = null;
        int foundDirs = 0;
        for (int i = this.parts.length - 1; i >= 0; --i) {
            IMount part = this.parts[i];
            if (!part.exists(path) || !part.isDirectory(path)) continue;
            if (foundFiles == null) {
                foundFiles = new ArrayList<String>();
            }
            part.list(path, foundFiles);
            ++foundDirs;
        }
        if (foundDirs == 1) {
            contents.addAll(foundFiles);
        } else if (foundDirs > 1) {
            HashSet<String> seen = new HashSet<String>();
            for (String file : foundFiles) {
                if (!seen.add(file)) continue;
                contents.add(file);
            }
        } else {
            throw new FileOperationException(path, "Not a directory");
        }
    }

    @Override
    public long getSize(@Nonnull String path) throws IOException {
        for (int i = this.parts.length - 1; i >= 0; --i) {
            IMount part = this.parts[i];
            if (!part.exists(path)) continue;
            return part.getSize(path);
        }
        throw new FileOperationException(path, "No such file");
    }

    @Override
    @Nonnull
    public ReadableByteChannel openForRead(@Nonnull String path) throws IOException {
        for (int i = this.parts.length - 1; i >= 0; --i) {
            IMount part = this.parts[i];
            if (!part.exists(path) || part.isDirectory(path)) continue;
            return part.openForRead(path);
        }
        throw new FileOperationException(path, "No such file");
    }

    @Override
    @Nonnull
    public BasicFileAttributes getAttributes(@Nonnull String path) throws IOException {
        for (int i = this.parts.length - 1; i >= 0; --i) {
            IMount part = this.parts[i];
            if (!part.exists(path) || part.isDirectory(path)) continue;
            return part.getAttributes(path);
        }
        throw new FileOperationException(path, "No such file");
    }
}

