/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.google.common.base.Objects;
import com.mojang.blaze3d.matrix.MatrixStack;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.render.TileEntityTurtleRenderer;
import dan200.computercraft.client.render.TurtleMultiModel;
import dan200.computercraft.shared.turtle.items.ItemTurtle;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.data.IModelData;

public class TurtleSmartItemModel
implements IBakedModel {
    private static final TransformationMatrix identity;
    private static final TransformationMatrix flip;
    private final IBakedModel familyModel;
    private final IBakedModel colourModel;
    private final HashMap<TurtleModelCombination, IBakedModel> cachedModels = new HashMap();
    private final ItemOverrideList overrides;

    public TurtleSmartItemModel(IBakedModel familyModel, IBakedModel colourModel) {
        this.familyModel = familyModel;
        this.colourModel = colourModel;
        this.overrides = new ItemOverrideList(){

            @Nonnull
            public IBakedModel func_239290_a_(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                ItemTurtle turtle = (ItemTurtle)stack.func_77973_b();
                int colour = turtle.getColour(stack);
                ITurtleUpgrade leftUpgrade = turtle.getUpgrade(stack, TurtleSide.LEFT);
                ITurtleUpgrade rightUpgrade = turtle.getUpgrade(stack, TurtleSide.RIGHT);
                ResourceLocation overlay = turtle.getOverlay(stack);
                boolean christmas = HolidayUtil.getCurrentHoliday() == Holiday.CHRISTMAS;
                String label = turtle.getLabel(stack);
                boolean flip = label != null && (label.equals("Dinnerbone") || label.equals("Grumm"));
                TurtleModelCombination combo = new TurtleModelCombination(colour != -1, leftUpgrade, rightUpgrade, overlay, christmas, flip);
                IBakedModel model = (IBakedModel)TurtleSmartItemModel.this.cachedModels.get(combo);
                if (model == null) {
                    model = TurtleSmartItemModel.this.buildModel(combo);
                    TurtleSmartItemModel.this.cachedModels.put(combo, model);
                }
                return model;
            }
        };
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private IBakedModel buildModel(TurtleModelCombination combo) {
        Minecraft mc = Minecraft.func_71410_x();
        ModelManager modelManager = mc.func_175599_af().func_175037_a().func_178083_a();
        ModelResourceLocation overlayModelLocation = TileEntityTurtleRenderer.getTurtleOverlayModel(combo.overlay, combo.christmas);
        IBakedModel baseModel = combo.colour ? this.colourModel : this.familyModel;
        IBakedModel overlayModel = overlayModelLocation != null ? modelManager.func_174953_a(overlayModelLocation) : null;
        TransformationMatrix transform = combo.flip ? flip : identity;
        TransformedModel leftModel = combo.leftUpgrade != null ? combo.leftUpgrade.getModel(null, TurtleSide.LEFT) : null;
        TransformedModel rightModel = combo.rightUpgrade != null ? combo.rightUpgrade.getModel(null, TurtleSide.RIGHT) : null;
        return new TurtleMultiModel(baseModel, overlayModel, transform, leftModel, rightModel);
    }

    @Nonnull
    @Deprecated
    public List<BakedQuad> func_200117_a(BlockState state, Direction facing, @Nonnull Random rand) {
        return this.familyModel.func_200117_a(state, facing, rand);
    }

    @Nonnull
    @Deprecated
    public List<BakedQuad> getQuads(BlockState state, Direction facing, @Nonnull Random rand, @Nonnull IModelData data) {
        return this.familyModel.getQuads(state, facing, rand, data);
    }

    public boolean func_177555_b() {
        return this.familyModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.familyModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.familyModel.func_188618_c();
    }

    public boolean func_230044_c_() {
        return this.familyModel.func_230044_c_();
    }

    @Nonnull
    @Deprecated
    public TextureAtlasSprite func_177554_e() {
        return this.familyModel.func_177554_e();
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.familyModel.func_177552_f();
    }

    static {
        MatrixStack stack = new MatrixStack();
        stack.func_227862_a_(0.0f, -1.0f, 0.0f);
        stack.func_227861_a_(0.0, 0.0, 1.0);
        identity = TransformationMatrix.func_227983_a_();
        flip = new TransformationMatrix(stack.func_227866_c_().func_227870_a_());
    }

    private static class TurtleModelCombination {
        final boolean colour;
        final ITurtleUpgrade leftUpgrade;
        final ITurtleUpgrade rightUpgrade;
        final ResourceLocation overlay;
        final boolean christmas;
        final boolean flip;

        TurtleModelCombination(boolean colour, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, ResourceLocation overlay, boolean christmas, boolean flip) {
            this.colour = colour;
            this.leftUpgrade = leftUpgrade;
            this.rightUpgrade = rightUpgrade;
            this.overlay = overlay;
            this.christmas = christmas;
            this.flip = flip;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof TurtleModelCombination)) {
                return false;
            }
            TurtleModelCombination otherCombo = (TurtleModelCombination)other;
            return otherCombo.colour == this.colour && otherCombo.leftUpgrade == this.leftUpgrade && otherCombo.rightUpgrade == this.rightUpgrade && Objects.equal((Object)otherCombo.overlay, (Object)this.overlay) && otherCombo.christmas == this.christmas && otherCombo.flip == this.flip;
        }

        public int hashCode() {
            int prime = 31;
            int result = 0;
            result = 31 * result + (this.colour ? 1 : 0);
            result = 31 * result + (this.leftUpgrade != null ? this.leftUpgrade.hashCode() : 0);
            result = 31 * result + (this.rightUpgrade != null ? this.rightUpgrade.hashCode() : 0);
            result = 31 * result + (this.overlay != null ? this.overlay.hashCode() : 0);
            result = 31 * result + (this.christmas ? 1 : 0);
            result = 31 * result + (this.flip ? 1 : 0);
            return result;
        }
    }
}

