/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public final class CableHighlightRenderer {
    private CableHighlightRenderer() {
    }

    @SubscribeEvent
    public static void drawHighlight(DrawHighlightEvent.HighlightBlock event) {
        BlockRayTraceResult hit = event.getTarget();
        BlockPos pos = hit.func_216350_a();
        World world = event.getInfo().func_216773_g().func_130014_f_();
        ActiveRenderInfo info = event.getInfo();
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != Registry.ModBlocks.CABLE.get() || ((CableModemVariant)((Object)state.func_177229_b(BlockCable.MODEM))).getFacing() == null || !((Boolean)state.func_177229_b((Property)BlockCable.CABLE)).booleanValue()) {
            return;
        }
        event.setCanceled(true);
        VoxelShape shape = WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) ? CableShapes.getModemShape(state) : CableShapes.getCableShape(state);
        Vector3d cameraPos = info.func_216785_c();
        double xOffset = (double)pos.func_177958_n() - cameraPos.func_82615_a();
        double yOffset = (double)pos.func_177956_o() - cameraPos.func_82617_b();
        double zOffset = (double)pos.func_177952_p() - cameraPos.func_82616_c();
        IVertexBuilder buffer = event.getBuffers().getBuffer(RenderType.func_228659_m_());
        Matrix4f matrix4f = event.getMatrix().func_227866_c_().func_227870_a_();
        shape.func_197754_a((x1, y1, z1, x2, y2, z2) -> {
            buffer.func_227888_a_(matrix4f, (float)(x1 + xOffset), (float)(y1 + yOffset), (float)(z1 + zOffset)).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)(x2 + xOffset), (float)(y2 + yOffset), (float)(z2 + zOffset)).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
        });
    }
}

