/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TurtleCompareCommand
implements ITurtleCommand {
    private final InteractDirection direction;

    public TurtleCompareCommand(InteractDirection direction) {
        this.direction = direction;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        BlockState lookAtState;
        Block lookAtBlock;
        Direction direction = this.direction.toWorldDir(turtle);
        ItemStack selectedStack = turtle.getInventory().func_70301_a(turtle.getSelectedSlot());
        World world = turtle.getWorld();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.func_177972_a(direction);
        ItemStack lookAtStack = ItemStack.field_190927_a;
        if (!world.func_175623_d(newPosition) && !(lookAtBlock = (lookAtState = world.func_180495_p(newPosition)).func_177230_c()).isAir(lookAtState, (IBlockReader)world, newPosition)) {
            block0: for (int i = 0; i < 5 && lookAtStack.func_190926_b(); ++i) {
                List drops = Block.func_220070_a((BlockState)lookAtState, (ServerWorld)((ServerWorld)world), (BlockPos)newPosition, (TileEntity)world.func_175625_s(newPosition));
                if (drops.isEmpty()) continue;
                for (ItemStack drop : drops) {
                    if (drop.func_77973_b() != lookAtBlock.func_199767_j()) continue;
                    lookAtStack = drop;
                    continue block0;
                }
            }
            if (lookAtStack.func_190926_b()) {
                lookAtStack = new ItemStack((IItemProvider)lookAtBlock);
            }
        }
        return selectedStack.func_77973_b() == lookAtStack.func_77973_b() ? TurtleCommandResult.success() : TurtleCommandResult.failure();
    }
}

