/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

class GenericPeripheral
implements IDynamicPeripheral {
    private final String type;
    private final TileEntity tile;
    private final List<SaturatedMethod> methods;

    GenericPeripheral(TileEntity tile, List<SaturatedMethod> methods) {
        ResourceLocation type = tile.func_200662_C().getRegistryName();
        this.tile = tile;
        this.type = type == null ? "unknown" : type.toString();
        this.methods = methods;
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        String[] names = new String[this.methods.size()];
        for (int i = 0; i < this.methods.size(); ++i) {
            names[i] = this.methods.get(i).getName();
        }
        return names;
    }

    @Override
    @Nonnull
    public MethodResult callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull IArguments arguments) throws LuaException {
        return this.methods.get(method).apply(context, computer, arguments);
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Object getTarget() {
        return this.tile;
    }

    @Override
    public boolean equals(@Nullable IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GenericPeripheral)) {
            return false;
        }
        GenericPeripheral generic = (GenericPeripheral)other;
        return this.tile == generic.tile && this.methods.equals(generic.methods);
    }
}

