/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes.replacement;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.ITargetingRule;
import java.util.regex.Pattern;
import net.minecraft.item.crafting.IRecipe;

public final class RegexTargetingRule
implements ITargetingRule {
    private final Pattern regex;
    private final boolean recipes;

    private RegexTargetingRule(Pattern regex, boolean recipes) {
        this.regex = regex;
        this.recipes = recipes;
    }

    public static RegexTargetingRule of(Pattern regex, boolean recipes) {
        return new RegexTargetingRule(regex, recipes);
    }

    public static RegexTargetingRule of(String regex, boolean recipes) {
        return new RegexTargetingRule(Pattern.compile(regex), recipes);
    }

    @Override
    public boolean shouldBeReplaced(IRecipe<?> recipe, IRecipeManager manager) {
        return this.regex.matcher((this.recipes ? recipe.func_199560_c() : manager.getBracketResourceLocation()).toString()).matches();
    }

    @Override
    public String describe() {
        return String.format("%s matching the regular expression %s", this.recipes ? "recipes" : "managers", this.regex.toString());
    }
}

