/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.upstream;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import corgitaco.upstream.config.UpstreamNoiseConfig;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="upstream")
public class Upstream {
    public static final String MOD_ID = "upstream";
    public static Logger LOGGER = LogManager.getLogger();
    public static Map<String, String> biomeToRiverMap;
    public static final Path CONFIG_PATH;

    public Upstream() {
        File dir = new File(CONFIG_PATH.toString());
        if (!dir.exists()) {
            dir.mkdir();
        }
        UpstreamNoiseConfig.loadConfig(UpstreamNoiseConfig.COMMON_CONFIG, CONFIG_PATH.resolve("upstream-noise.toml"));
    }

    public static void handleUpstreamRiverConfig(Path path, Map<String, String> biomeRiverMap) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(Comparator.comparing(String::toString));
        sortedMap.putAll(biomeRiverMap);
        File CONFIG_FILE = new File(String.valueOf(path));
        if (!CONFIG_FILE.exists()) {
            Upstream.createRiverJson(path, sortedMap);
        }
        try (FileReader reader = new FileReader(path.toString());){
            Map biomeDataListHolder = (Map)gson.fromJson((Reader)reader, Map.class);
            if (biomeDataListHolder != null) {
                biomeToRiverMap = biomeDataListHolder;
            } else {
                LOGGER.error("upstream-rivers.json could not be read");
            }
        }
        catch (IOException e) {
            LOGGER.error("upstream-rivers.json could not be read");
        }
    }

    public static void createRiverJson(Path path, Map<String, String> biomeRiverMap) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(biomeRiverMap);
        try {
            Files.write(path, jsonString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("upstream-rivers.json could not be created");
        }
    }

    static {
        CONFIG_PATH = new File(String.valueOf(FMLPaths.CONFIGDIR.get().resolve(MOD_ID))).toPath();
    }
}

