/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import mod.beethoven92.betterendforge.common.world.generator.WeighTree;
import net.minecraft.util.ResourceLocation;

public class BiomePicker {
    private final Set<ResourceLocation> immutableIDs = Sets.newHashSet();
    private final List<BetterEndBiome> biomes = Lists.newArrayList();
    private float maxChanceUnmutable = 0.0f;
    private float maxChance = 0.0f;
    private int biomeCount = 0;
    private WeighTree tree;

    public void addBiome(BetterEndBiome biome) {
        this.maxChance = biome.mutateGenChance(this.maxChance);
        this.immutableIDs.add(biome.getID());
        this.maxChanceUnmutable = this.maxChance;
        this.biomes.add(biome);
        ++this.biomeCount;
    }

    public void addBiomeMutable(BetterEndBiome biome) {
        this.biomes.add(biome);
    }

    public void clearMutables() {
        this.maxChance = this.maxChanceUnmutable;
        for (int i = this.biomes.size() - 1; i >= this.biomeCount; --i) {
            this.biomes.remove(i);
        }
    }

    public BetterEndBiome getBiome(Random random) {
        return this.biomes.isEmpty() ? null : this.tree.getBiome(random.nextFloat() * this.maxChance);
    }

    public List<BetterEndBiome> getBiomes() {
        return this.biomes;
    }

    public boolean containsImmutable(ResourceLocation id) {
        return this.immutableIDs.contains(id);
    }

    public void removeMutableBiome(ResourceLocation id) {
        for (int i = this.biomeCount; i < this.biomes.size(); ++i) {
            BetterEndBiome biome = this.biomes.get(i);
            if (!biome.getID().equals((Object)id)) continue;
            this.biomes.remove(i);
            break;
        }
    }

    public void rebuild() {
        if (this.biomes.isEmpty()) {
            return;
        }
        this.maxChance = this.maxChanceUnmutable;
        for (int i = this.biomeCount; i < this.biomes.size(); ++i) {
            this.maxChance = this.biomes.get(i).mutateGenChance(this.maxChance);
        }
        this.tree = new WeighTree(this.biomes);
    }
}

