/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFRotation;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnion;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFCappedCone;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class IceStarFeature
extends Feature<NoFeatureConfig> {
    private final float minSize;
    private final float maxSize;
    private final int minCount;
    private final int maxCount;

    public IceStarFeature(float minSize, float maxSize, int minCount, int maxCount) {
        super(NoFeatureConfig.field_236558_a_);
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        float size = ModMathHelper.randRange(this.minSize, this.maxSize, rand);
        int count = ModMathHelper.randRange(this.minCount, this.maxCount, rand);
        List<Vector3f> points = this.getFibonacciPoints(count);
        SDF sdf = null;
        SDF spike = new SDFCappedCone().setRadius1(3.0f + (size - 5.0f) * 0.2f).setRadius2(0.0f).setHeight(size).setBlock((Block)ModBlocks.DENSE_SNOW.get());
        spike = new SDFTranslate().setTranslate(0.0f, size - 0.5f, 0.0f).setSource(spike);
        for (Vector3f point : points) {
            SDF rotated = spike;
            float angle = ModMathHelper.angle(Vector3f.field_229181_d_, point = ModMathHelper.normalize(point));
            if (angle > 0.01f && angle < 3.14f) {
                Vector3f axis = ModMathHelper.normalize(ModMathHelper.cross(Vector3f.field_229181_d_, point));
                rotated = new SDFRotation().setRotation(axis, angle).setSource(spike);
            } else if (angle > 1.0f) {
                rotated = new SDFRotation().setRotation(Vector3f.field_229181_d_, (float)Math.PI).setSource(spike);
            }
            sdf = sdf == null ? rotated : new SDFUnion().setSourceA(sdf).setSourceB(rotated);
        }
        int x1 = pos.func_177958_n() >> 4 << 4;
        int z1 = pos.func_177952_p() >> 4 << 4;
        pos = new BlockPos(x1 + rand.nextInt(16), ModMathHelper.randRange(32, 128, rand), z1 + rand.nextInt(16));
        float ancientRadius = size * 0.7f;
        float denseRadius = size * 0.9f;
        float iceRadius = size < 7.0f ? size * 5.0f : size * 1.3f;
        float randScale = size * 0.3f;
        BlockPos center = pos;
        BlockState ice = ((Block)ModBlocks.EMERALD_ICE.get()).func_176223_P();
        BlockState dense = ((Block)ModBlocks.DENSE_EMERALD_ICE.get()).func_176223_P();
        BlockState ancient = ((Block)ModBlocks.ANCIENT_EMERALD_ICE.get()).func_176223_P();
        SDF sdfCopy = sdf;
        sdf.addPostProcess(info -> {
            float pz;
            float py;
            BlockPos bpos = info.getPos();
            float px = bpos.func_177958_n() - center.func_177958_n();
            float distance = ModMathHelper.length(px, py = (float)(bpos.func_177956_o() - center.func_177956_o()), pz = (float)(bpos.func_177952_p() - center.func_177952_p())) + sdfCopy.getDistance(px, py, pz) * 0.4f + rand.nextFloat() * randScale;
            if (distance < ancientRadius) {
                return ancient;
            }
            if (distance < denseRadius) {
                return dense;
            }
            if (distance < iceRadius) {
                return ice;
            }
            return info.getState();
        }).fillRecursive((IWorld)world, pos);
        return true;
    }

    private List<Vector3f> getFibonacciPoints(int count) {
        float max = count - 1;
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(count);
        for (int i = 0; i < count; ++i) {
            float y = 1.0f - (float)i / max * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = ModMathHelper.PHI * (float)i;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            result.add(new Vector3f(x, y, z));
        }
        return result;
    }
}

