/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public abstract class FullHeightScatterFeature
extends Feature<NoFeatureConfig> {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private final int radius;

    public FullHeightScatterFeature(int radius) {
        super(NoFeatureConfig.field_236558_a_);
        this.radius = radius;
    }

    public abstract boolean canGenerate(ISeedReader var1, Random var2, BlockPos var3, BlockPos var4, float var5);

    public abstract void generate(ISeedReader var1, Random var2, BlockPos var3);

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos center, NoFeatureConfig config) {
        int maxY = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, center.func_177958_n(), center.func_177952_p());
        int minY = BlockHelper.upRay((IWorldReader)world, new BlockPos(center.func_177958_n(), 0, center.func_177952_p()), maxY);
        for (int y = maxY; y > minY; --y) {
            POS.func_181079_c(center.func_177958_n(), y, center.func_177952_p());
            if (!world.func_180495_p((BlockPos)POS).func_196958_f() || world.func_180495_p(POS.func_177977_b()).func_196958_f()) continue;
            float r = ModMathHelper.randRange((float)this.radius * 0.5f, (float)this.radius, random);
            int count = ModMathHelper.floor(r * r * ModMathHelper.randRange(1.5f, 3.0f, random));
            for (int i = 0; i < count; ++i) {
                float pr = r * (float)Math.sqrt(random.nextFloat());
                float theta = random.nextFloat() * ((float)Math.PI * 2);
                float x = pr * (float)Math.cos(theta);
                float z = pr * (float)Math.sin(theta);
                POS.func_189532_c((double)((float)center.func_177958_n() + x), (double)(y + 5), (double)((float)center.func_177952_p() + z));
                int down = BlockHelper.downRay((IWorldReader)world, (BlockPos)POS, 16);
                if (down > 10) continue;
                POS.func_185336_p(POS.func_177956_o() - down);
                if (!this.canGenerate(world, random, center, (BlockPos)POS, r)) continue;
                this.generate(world, random, (BlockPos)POS);
            }
        }
        return true;
    }
}

