/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mod.beethoven92.betterendforge.common.recipes.InfusionRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InfusionRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<InfusionRecipe> {
    public InfusionRecipe read(ResourceLocation id, JsonObject json) {
        int i;
        InfusionRecipe recipe = new InfusionRecipe(id);
        recipe.input = Ingredient.func_199802_a((JsonElement)json.get("input"));
        ResourceLocation outId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"output"));
        recipe.output = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(outId).orElseThrow(() -> new IllegalStateException("Item: " + outId + " does not exists!")));
        recipe.time = JSONUtils.func_151208_a((JsonObject)json, (String)"time", (int)1);
        JsonArray catalysts = JSONUtils.func_151214_t((JsonObject)json, (String)"catalysts");
        for (i = 0; i < catalysts.size(); ++i) {
            JsonObject indexedIngredient = catalysts.get(i).getAsJsonObject();
            int index = JSONUtils.func_151203_m((JsonObject)indexedIngredient, (String)"index");
            if (index < 0 || index > 7) {
                throw new IllegalStateException("BETTER_END_FORGE: Infusion recipe ingredient index out of bounds, must be between 0 and 8 (excluded)");
            }
            Ingredient item = Ingredient.func_199802_a((JsonElement)indexedIngredient);
            recipe.ingredientPositions.put(index, item);
        }
        for (i = 0; i < 8; ++i) {
            recipe.catalysts[i] = recipe.ingredientPositions.containsKey(i) ? recipe.ingredientPositions.get(i) : Ingredient.field_193370_a;
        }
        return recipe;
    }

    public InfusionRecipe read(ResourceLocation id, PacketBuffer buffer) {
        int i;
        InfusionRecipe recipe = new InfusionRecipe(id);
        recipe.input = Ingredient.func_199566_b((PacketBuffer)buffer);
        recipe.output = buffer.func_150791_c();
        recipe.time = buffer.func_150792_a();
        int[] index_array = new int[8];
        for (i = 0; i < 8; ++i) {
            index_array[i] = buffer.func_150792_a();
        }
        for (i = 0; i < 8; ++i) {
            if (index_array[i] != -1) {
                int index = buffer.func_150792_a();
                recipe.catalysts[i] = Ingredient.func_199566_b((PacketBuffer)buffer);
                continue;
            }
            recipe.catalysts[i] = Ingredient.field_193370_a;
        }
        return recipe;
    }

    public void write(PacketBuffer buffer, InfusionRecipe recipe) {
        int i;
        recipe.input.func_199564_a(buffer);
        buffer.func_150788_a(recipe.output);
        buffer.func_150787_b(recipe.time);
        for (i = 0; i < 8; ++i) {
            if (recipe.catalysts[i] != Ingredient.field_193370_a) {
                buffer.func_150787_b(i);
                continue;
            }
            buffer.func_150787_b(-1);
        }
        for (i = 0; i < 8; ++i) {
            if (recipe.catalysts[i] == Ingredient.field_193370_a) continue;
            buffer.func_150787_b(i);
            recipe.catalysts[i].func_199564_a(buffer);
        }
    }
}

