/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mod.beethoven92.betterendforge.common.util.JsonFactory;
import mod.beethoven92.betterendforge.common.world.biome.AmberLandBiome;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndCaveBiome;
import mod.beethoven92.betterendforge.common.world.biome.BlossomingSpiresBiome;
import mod.beethoven92.betterendforge.common.world.biome.ChorusForestBiome;
import mod.beethoven92.betterendforge.common.world.biome.CrystalMountainsBiome;
import mod.beethoven92.betterendforge.common.world.biome.DragonGraveyardsBiome;
import mod.beethoven92.betterendforge.common.world.biome.DryShrublandBiome;
import mod.beethoven92.betterendforge.common.world.biome.DustWastelandsBiome;
import mod.beethoven92.betterendforge.common.world.biome.FoggyMushroomlandBiome;
import mod.beethoven92.betterendforge.common.world.biome.GlowingGrasslandsBiome;
import mod.beethoven92.betterendforge.common.world.biome.IceStarfieldBiome;
import mod.beethoven92.betterendforge.common.world.biome.LanternWoodsBiome;
import mod.beethoven92.betterendforge.common.world.biome.MegalakeBiome;
import mod.beethoven92.betterendforge.common.world.biome.MegalakeGroveBiome;
import mod.beethoven92.betterendforge.common.world.biome.NeonOasisBiome;
import mod.beethoven92.betterendforge.common.world.biome.PaintedMountainsBiome;
import mod.beethoven92.betterendforge.common.world.biome.ShadowForestBiome;
import mod.beethoven92.betterendforge.common.world.biome.SulphurSpringsBiome;
import mod.beethoven92.betterendforge.common.world.biome.UmbrellaJungleBiome;
import mod.beethoven92.betterendforge.common.world.biome.cave.EmptyAuroraCaveBiome;
import mod.beethoven92.betterendforge.common.world.biome.cave.EmptyEndCaveBiome;
import mod.beethoven92.betterendforge.common.world.biome.cave.EmptySmaragdantCaveBiome;
import mod.beethoven92.betterendforge.common.world.biome.cave.LushAuroraCaveBiome;
import mod.beethoven92.betterendforge.common.world.biome.cave.LushSmaragdantCaveBiome;
import mod.beethoven92.betterendforge.common.world.generator.BiomePicker;
import mod.beethoven92.betterendforge.common.world.generator.EndBiomeType;
import mod.beethoven92.betterendforge.config.jsons.JsonConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModBiomes {
    private static final HashMap<ResourceLocation, BetterEndBiome> ID_MAP = Maps.newHashMap();
    private static final HashMap<Biome, BetterEndBiome> CLIENT = Maps.newHashMap();
    private static final Set<ResourceLocation> SUBBIOMES_UNMUTABLES = Sets.newHashSet();
    public static final BiomePicker LAND_BIOMES = new BiomePicker();
    public static final BiomePicker VOID_BIOMES = new BiomePicker();
    public static final BiomePicker CAVE_BIOMES = new BiomePicker();
    public static final List<BetterEndBiome> SUBBIOMES = Lists.newArrayList();
    private static final JsonObject EMPTY_JSON = new JsonObject();
    private static Registry<Biome> biomeRegistry;
    public static final BetterEndBiome END;
    public static final BetterEndBiome END_MIDLANDS;
    public static final BetterEndBiome END_HIGHLANDS;
    public static final BetterEndBiome END_BARRENS;
    public static final BetterEndBiome SMALL_END_ISLANDS;
    public static final BetterEndBiome MEGALAKE;
    public static final BetterEndBiome CRYSTAL_MOUNTAINS;
    public static final BetterEndBiome FOGGY_MUSHROOMLAND;
    public static final BetterEndBiome MEGALAKE_GROVE;
    public static final BetterEndBiome DUST_WASTELANDS;
    public static final BetterEndBiome PAINTED_MOUNTAINS;
    public static final BetterEndBiome CHORUS_FOREST;
    public static final BetterEndBiome SHADOW_FOREST;
    public static final BetterEndBiome BLOSSOMING_SPIRES;
    public static final BetterEndBiome SULPHUR_SPRINGS;
    public static final BetterEndBiome AMBER_LAND;
    public static final BetterEndBiome UMBRELLA_JUNGLE;
    public static final BetterEndBiome GLOWING_GRASSLANDS;
    public static final BetterEndBiome DRAGON_GRAVEYARDS;
    public static final BetterEndBiome LANTERN_WOODS;
    public static final BetterEndBiome DRY_SHRUBLAND;
    public static final BetterEndBiome NEON_OASIS;
    public static final BetterEndBiome ICE_STARFIELD;
    public static final BetterEndCaveBiome EMPTY_END_CAVE;
    public static final BetterEndCaveBiome EMPTY_SMARAGDANT_CAVE;
    public static final BetterEndCaveBiome LUSH_SMARAGDANT_CAVE;
    public static final BetterEndCaveBiome EMPTY_AURORA_CAVE;
    public static final BetterEndCaveBiome LUSH_AURORA_CAVE;

    public static void register() {
    }

    public static void mutateRegistry(Registry<Biome> biomeRegistry) {
        ModBiomes.biomeRegistry = biomeRegistry;
        LAND_BIOMES.clearMutables();
        VOID_BIOMES.clearMutables();
        CAVE_BIOMES.clearMutables();
        HashMap configs = Maps.newHashMap();
        biomeRegistry.forEach(biome -> {
            ResourceLocation id;
            if (biome.func_201856_r() == Biome.Category.THEEND && JsonConfigs.BIOME_CONFIG.getBoolean(id = biomeRegistry.func_177774_c(biome), "enabled", true) && !LAND_BIOMES.containsImmutable(id) && !VOID_BIOMES.containsImmutable(id) && !SUBBIOMES_UNMUTABLES.contains(id)) {
                JsonObject config = (JsonObject)configs.get(id.func_110624_b());
                if (config == null) {
                    config = ModBiomes.loadJsonConfig(id.func_110624_b());
                    configs.put(id.func_110624_b(), config);
                }
                float fog = 1.0f;
                float chance = 1.0f;
                boolean isVoid = false;
                boolean hasCaves = true;
                JsonElement element = config.get(id.func_110623_a());
                if (element != null && element.isJsonObject()) {
                    fog = JsonFactory.getFloat(element.getAsJsonObject(), "fog_density", 1.0f);
                    chance = JsonFactory.getFloat(element.getAsJsonObject(), "generation_chance", 1.0f);
                    isVoid = JsonFactory.getString(element.getAsJsonObject(), "type", "land").equals("void");
                    hasCaves = JsonFactory.getBoolean(element.getAsJsonObject(), "has_caves", true);
                }
                BetterEndBiome endBiome = new BetterEndBiome(id, (Biome)biome, fog, chance, hasCaves);
                if (isVoid) {
                    VOID_BIOMES.addBiomeMutable(endBiome);
                } else {
                    LAND_BIOMES.addBiomeMutable(endBiome);
                }
                ID_MAP.put(id, endBiome);
            }
        });
        JsonConfigs.BIOME_CONFIG.saveChanges();
        ModBiomes.rebuildPicker(LAND_BIOMES, biomeRegistry);
        ModBiomes.rebuildPicker(VOID_BIOMES, biomeRegistry);
        ModBiomes.rebuildPicker(CAVE_BIOMES, biomeRegistry);
        SUBBIOMES.forEach(endBiome -> endBiome.updateActualBiomes(biomeRegistry));
        CLIENT.clear();
    }

    private static void rebuildPicker(BiomePicker picker, Registry<Biome> biomeRegistry) {
        picker.rebuild();
        picker.getBiomes().forEach(endBiome -> endBiome.updateActualBiomes(biomeRegistry));
    }

    private static JsonObject loadJsonConfig(String namespace) {
        InputStream inputstream = ModBiomes.class.getResourceAsStream("/data/" + namespace + "/end_biome_properties.json");
        if (inputstream != null) {
            return JsonFactory.getJsonObject(inputstream);
        }
        return EMPTY_JSON;
    }

    public static void initRegistry(MinecraftServer server) {
        if (biomeRegistry == null) {
            biomeRegistry = server.func_244267_aX().func_243612_b(Registry.field_239720_u_);
        }
    }

    public static BetterEndBiome registerBiome(Biome biome, EndBiomeType type, float genChance) {
        return ModBiomes.registerBiome(biome, type, 1.0f, genChance);
    }

    public static BetterEndBiome registerBiome(Biome biome, EndBiomeType type, float fogDensity, float genChance) {
        BetterEndBiome endBiome = new BetterEndBiome(WorldGenRegistries.field_243657_i.func_177774_c((Object)biome), biome, fogDensity, genChance, true);
        if (JsonConfigs.BIOME_CONFIG.getBoolean(endBiome.getID(), "enabled", true)) {
            ModBiomes.addToPicker(endBiome, type);
        }
        return endBiome;
    }

    public static BetterEndBiome registerSubBiome(Biome biome, BetterEndBiome parent, float genChance, boolean hasCaves) {
        return ModBiomes.registerSubBiome(biome, parent, 1.0f, genChance, hasCaves);
    }

    public static BetterEndBiome registerSubBiome(Biome biome, BetterEndBiome parent, float fogDensity, float genChance, boolean hasCaves) {
        BetterEndBiome endBiome = new BetterEndBiome(WorldGenRegistries.field_243657_i.func_177774_c((Object)biome), biome, fogDensity, genChance, hasCaves);
        if (JsonConfigs.BIOME_CONFIG.getBoolean(endBiome.getID(), "enabled", true)) {
            parent.addSubBiome(endBiome);
            SUBBIOMES.add(endBiome);
            SUBBIOMES_UNMUTABLES.add(endBiome.getID());
            ID_MAP.put(endBiome.getID(), endBiome);
        }
        return endBiome;
    }

    public static BetterEndBiome registerBiome(BetterEndBiome biome, EndBiomeType type) {
        ModBiomes.registerBiomeDirect(biome);
        if (JsonConfigs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            ModBiomes.addToPicker(biome, type);
            ID_MAP.put(biome.getID(), biome);
        }
        return biome;
    }

    public static BetterEndBiome registerSubBiome(BetterEndBiome biome, BetterEndBiome parent) {
        ModBiomes.registerBiomeDirect(biome);
        if (JsonConfigs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            parent.addSubBiome(biome);
            SUBBIOMES.add(biome);
            SUBBIOMES_UNMUTABLES.add(biome.getID());
            ID_MAP.put(biome.getID(), biome);
        }
        return biome;
    }

    private static BetterEndBiome registerBiome(RegistryKey<Biome> key, EndBiomeType type, float genChance) {
        return ModBiomes.registerBiome((Biome)WorldGenRegistries.field_243657_i.func_243576_d(key), type, genChance);
    }

    private static BetterEndBiome registerSubBiome(RegistryKey<Biome> key, BetterEndBiome parent, float genChance) {
        return ModBiomes.registerSubBiome((Biome)WorldGenRegistries.field_243657_i.func_243576_d(key), parent, genChance, true);
    }

    private static void addToPicker(BetterEndBiome biome, EndBiomeType type) {
        if (type == EndBiomeType.LAND) {
            LAND_BIOMES.addBiome(biome);
        } else {
            VOID_BIOMES.addBiome(biome);
        }
    }

    private static void registerBiomeDirect(BetterEndBiome biome) {
        if (JsonConfigs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            biome.getBiome().setRegistryName(biome.getID());
        }
    }

    public static BetterEndBiome getFromBiome(Biome biome) {
        return ID_MAP.getOrDefault(biomeRegistry.func_177774_c((Object)biome), END);
    }

    public static ResourceLocation getBiomeID(Biome biome) {
        ResourceLocation id = biomeRegistry.func_177774_c((Object)biome);
        return id == null ? END.getID() : id;
    }

    public static BetterEndBiome getBiome(ResourceLocation biomeID) {
        return ID_MAP.getOrDefault(biomeID, END);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BetterEndBiome getRenderBiome(Biome biome) {
        BetterEndBiome endBiome = CLIENT.get(biome);
        if (endBiome == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ResourceLocation id = minecraft.field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
            endBiome = id == null ? END : ID_MAP.getOrDefault(id, END);
            CLIENT.put(biome, endBiome);
        }
        return endBiome;
    }

    public static List<BetterEndBiome> getModBiomes() {
        ArrayList result = Lists.newArrayList();
        result.addAll(LAND_BIOMES.getBiomes());
        result.addAll(VOID_BIOMES.getBiomes());
        result.addAll(CAVE_BIOMES.getBiomes());
        result.addAll(SUBBIOMES);
        return result;
    }

    public static BetterEndCaveBiome registerCaveBiome(BetterEndCaveBiome biome) {
        ModBiomes.registerBiomeDirect(biome);
        if (JsonConfigs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            CAVE_BIOMES.addBiome(biome);
            ID_MAP.put(biome.getID(), biome);
        }
        return biome;
    }

    public static BetterEndCaveBiome getCaveBiome(Random random) {
        return (BetterEndCaveBiome)CAVE_BIOMES.getBiome(random);
    }

    public static boolean hasBiome(ResourceLocation biomeID) {
        return ID_MAP.containsKey(biomeID);
    }

    static {
        END = ModBiomes.registerBiome((RegistryKey<Biome>)Biomes.field_76779_k, EndBiomeType.LAND, 1.0f);
        END_MIDLANDS = ModBiomes.registerSubBiome((RegistryKey<Biome>)Biomes.field_201937_Q, END, 0.5f);
        END_HIGHLANDS = ModBiomes.registerSubBiome((RegistryKey<Biome>)Biomes.field_201938_R, END, 0.5f);
        END_BARRENS = ModBiomes.registerBiome((RegistryKey<Biome>)Biomes.field_201939_S, EndBiomeType.VOID, 1.0f);
        SMALL_END_ISLANDS = ModBiomes.registerBiome((RegistryKey<Biome>)Biomes.field_201936_P, EndBiomeType.VOID, 1.0f);
        MEGALAKE = ModBiomes.registerBiome(new MegalakeBiome(), EndBiomeType.LAND);
        CRYSTAL_MOUNTAINS = ModBiomes.registerBiome(new CrystalMountainsBiome(), EndBiomeType.LAND);
        FOGGY_MUSHROOMLAND = ModBiomes.registerBiome(new FoggyMushroomlandBiome(), EndBiomeType.LAND);
        MEGALAKE_GROVE = ModBiomes.registerSubBiome(new MegalakeGroveBiome(), MEGALAKE);
        DUST_WASTELANDS = ModBiomes.registerBiome(new DustWastelandsBiome(), EndBiomeType.LAND);
        PAINTED_MOUNTAINS = ModBiomes.registerSubBiome(new PaintedMountainsBiome(), DUST_WASTELANDS);
        CHORUS_FOREST = ModBiomes.registerBiome(new ChorusForestBiome(), EndBiomeType.LAND);
        SHADOW_FOREST = ModBiomes.registerBiome(new ShadowForestBiome(), EndBiomeType.LAND);
        BLOSSOMING_SPIRES = ModBiomes.registerBiome(new BlossomingSpiresBiome(), EndBiomeType.LAND);
        SULPHUR_SPRINGS = ModBiomes.registerBiome(new SulphurSpringsBiome(), EndBiomeType.LAND);
        AMBER_LAND = ModBiomes.registerBiome(new AmberLandBiome(), EndBiomeType.LAND);
        UMBRELLA_JUNGLE = ModBiomes.registerBiome(new UmbrellaJungleBiome(), EndBiomeType.LAND);
        GLOWING_GRASSLANDS = ModBiomes.registerBiome(new GlowingGrasslandsBiome(), EndBiomeType.LAND);
        DRAGON_GRAVEYARDS = ModBiomes.registerBiome(new DragonGraveyardsBiome(), EndBiomeType.LAND);
        LANTERN_WOODS = ModBiomes.registerBiome(new LanternWoodsBiome(), EndBiomeType.LAND);
        DRY_SHRUBLAND = ModBiomes.registerBiome(new DryShrublandBiome(), EndBiomeType.LAND);
        NEON_OASIS = ModBiomes.registerSubBiome(new NeonOasisBiome(), DUST_WASTELANDS);
        ICE_STARFIELD = ModBiomes.registerBiome(new IceStarfieldBiome(), EndBiomeType.VOID);
        EMPTY_END_CAVE = ModBiomes.registerCaveBiome(new EmptyEndCaveBiome());
        EMPTY_SMARAGDANT_CAVE = ModBiomes.registerCaveBiome(new EmptySmaragdantCaveBiome());
        LUSH_SMARAGDANT_CAVE = ModBiomes.registerCaveBiome(new LushSmaragdantCaveBiome());
        EMPTY_AURORA_CAVE = ModBiomes.registerCaveBiome(new EmptyAuroraCaveBiome());
        LUSH_AURORA_CAVE = ModBiomes.registerCaveBiome(new LushAuroraCaveBiome());
    }
}

