/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block;

import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.template.PedestalBlock;
import mod.beethoven92.betterendforge.common.init.ModTileEntityTypes;
import mod.beethoven92.betterendforge.common.rituals.EternalRitual;
import mod.beethoven92.betterendforge.common.teleporter.EndPortals;
import mod.beethoven92.betterendforge.common.tileentity.EternalPedestalTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EternalPedestal
extends PedestalBlock {
    public static final BooleanProperty ACTIVATED = BlockProperties.ACTIVATED;

    public EternalPedestal(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity blockEntity;
        ActionResultType result = super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        if (result.equals((Object)ActionResultType.SUCCESS) && (blockEntity = worldIn.func_175625_s(pos)) instanceof EternalPedestalTileEntity) {
            EternalPedestalTileEntity pedestal = (EternalPedestalTileEntity)blockEntity;
            BlockState updatedState = worldIn.func_180495_p(pos);
            if (pedestal.isEmpty() && ((Boolean)updatedState.func_177229_b((Property)ACTIVATED)).booleanValue()) {
                if (pedestal.hasRitual()) {
                    EternalRitual ritual = pedestal.getRitual();
                    Item item = pedestal.getStack().func_77973_b();
                    int dim = EndPortals.getPortalState(Registry.field_212630_s.func_177774_c((Object)item));
                    ritual.removePortal(dim);
                }
                worldIn.func_175656_a(pos, (BlockState)updatedState.func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
            } else {
                ItemStack itemStack = pedestal.getStack();
                ResourceLocation id = Registry.field_212630_s.func_177774_c((Object)itemStack.func_77973_b());
                if (EndPortals.isAvailableItem(id)) {
                    worldIn.func_175656_a(pos, (BlockState)updatedState.func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
                    if (pedestal.hasRitual()) {
                        pedestal.getRitual().checkStructure();
                    } else {
                        EternalRitual ritual = new EternalRitual(worldIn, pos);
                        ritual.checkStructure();
                    }
                }
            }
        }
        return result;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState updated = super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!updated.func_203425_a((Block)this)) {
            return updated;
        }
        if (!this.isPlaceable(updated)) {
            return (BlockState)updated.func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        }
        return updated;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ACTIVATED});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.ETERNAL_PEDESTAL.get()).func_200968_a();
    }
}

