/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.ScaleUtils;

public class ScalePacket {
    final int id;
    final ResourceLocation typeId;
    CompoundNBT nbt = null;
    ScaleData scaleData = null;

    public ScalePacket(ScaleData scaleData) {
        Entity e = scaleData.getEntity();
        this.id = e != null ? e.func_145782_y() : -1;
        this.typeId = ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, scaleData.getScaleType());
        this.scaleData = scaleData;
    }

    protected ScalePacket(PacketBuffer buf) {
        this.id = buf.func_150792_a();
        this.typeId = buf.func_192575_l();
        this.nbt = ScaleUtils.buildScaleNbtFromPacketByteBuf(buf);
    }

    public static void handle(ScalePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Entity entity;
            if (ScaleRegistries.SCALE_TYPES.containsKey((Object)msg.typeId) && (entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.id)) != null) {
                ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, msg.typeId).getScaleData(entity).readNbt(msg.nbt);
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.id);
        buf.func_192572_a(this.typeId);
        this.scaleData.toPacket(buf);
    }
}

