/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import virtuoel.pehkui.mixin.LivingEntityMixin;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin {
    @Unique
    private static final ThreadLocal<Float> WIDTH_SCALE = ThreadLocal.withInitial(() -> Float.valueOf(1.0f));
    @Unique
    private static final ThreadLocal<Float> HEIGHT_SCALE = ThreadLocal.withInitial(() -> Float.valueOf(1.0f));

    @Inject(at={@At(value="RETURN")}, method={"getDimensions"}, cancellable=true)
    private void onGetDimensions(Pose pose, CallbackInfoReturnable<EntitySize> info) {
        info.setReturnValue((Object)((EntitySize)info.getReturnValue()).func_220312_a(ScaleUtils.getBoundingBoxWidthScale((Entity)this), ScaleUtils.getBoundingBoxHeightScale((Entity)this)));
    }

    @ModifyArg(method={"tickMovement"}, index=1, at=@At(value="INVOKE", target="Ljava/lang/Math;min(FF)F"))
    private float onTickMovementMinVelocityProxy(float velocity) {
        return velocity * ScaleUtils.getMotionScale((Entity)this);
    }

    @Inject(method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ItemEntity;setPickupDelay(I)V")})
    private void onDropItem(ItemStack stack, boolean spread, boolean thrown, CallbackInfoReturnable<ItemEntity> info, double y, ItemEntity entity) {
        float scale = ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
        if (scale != 1.0f) {
            Vector3d pos = entity.func_213303_ch();
            entity.func_242281_f(pos.field_72450_a, y + (double)(1.0f - scale) * 0.3, pos.field_72449_c);
        }
    }

    @ModifyArg(method={"tickMovement()V"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double onTickMovementExpandXProxy(double value) {
        return value * (double)ScaleUtils.getMotionScale((Entity)this);
    }

    @ModifyArg(method={"tickMovement()V"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double onTickMovementExpandYProxy(double value) {
        return value * (double)ScaleUtils.getMotionScale((Entity)this);
    }

    @ModifyArg(method={"tickMovement()V"}, index=2, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double onTickMovementExpandZProxy(double value) {
        return value * (double)ScaleUtils.getMotionScale((Entity)this);
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    private void onAttack(Entity target, CallbackInfo info) {
        WIDTH_SCALE.set(Float.valueOf(ScaleUtils.getBoundingBoxWidthScale(target)));
        HEIGHT_SCALE.set(Float.valueOf(ScaleUtils.getBoundingBoxHeightScale(target)));
    }

    @ModifyArg(method={"attack(Lnet/minecraft/entity/Entity;)V"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double onAttackExpandXProxy(double value) {
        return value * (double)WIDTH_SCALE.get().floatValue();
    }

    @ModifyArg(method={"attack(Lnet/minecraft/entity/Entity;)V"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double onAttackExpandYProxy(double value) {
        return value * (double)HEIGHT_SCALE.get().floatValue();
    }

    @ModifyArg(method={"attack(Lnet/minecraft/entity/Entity;)V"}, index=2, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double onAttackExpandZProxy(double value) {
        return value * (double)WIDTH_SCALE.get().floatValue();
    }
}

