/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.pehkui.mixin.EntityMixin;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={AbstractArrowEntity.class})
public abstract class PersistentProjectileEntityMixin
extends EntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/world/World;)V"})
    private void onConstruct(EntityType<? extends ProjectileEntity> type, LivingEntity owner, World world, CallbackInfo info) {
        float scale = ScaleUtils.getEyeHeightScale((Entity)owner);
        if (scale != 1.0f) {
            Entity self = (Entity)this;
            Vector3d pos = self.func_213303_ch();
            self.func_226288_n_(pos.field_72450_a, pos.field_72448_b + (double)(1.0f - scale) * 0.1, pos.field_72449_c);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setOwner"})
    private void onSetOwner(@Nullable Entity entity, CallbackInfo info) {
        if (entity != null) {
            ScaleUtils.setScaleOfProjectile((Entity)this, entity);
        }
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(doubleValue=0.05000000074505806)})
    private double tickModifyGravity(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale != 1.0f ? (double)scale * value : value;
    }
}

