/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import net.minecraft.util.ResourceLocation;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.TypedScaleModifier;

public class ScaleModifier
implements Comparable<ScaleModifier> {
    public static final ScaleModifier IDENTITY = ScaleModifier.register(ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_MODIFIERS));
    public static final ScaleModifier BASE_MULTIPLIER = ScaleModifier.register("base_multiplier", (ScaleModifier)new TypedScaleModifier(() -> ScaleType.BASE));
    public static final ScaleModifier MOTION_MULTIPLIER = ScaleModifier.register("motion_multiplier", (ScaleModifier)new TypedScaleModifier(() -> ScaleType.MOTION));
    public static final ScaleModifier MOTION_DIVISOR = ScaleModifier.register("motion_divisor", (ScaleModifier)new TypedScaleModifier(() -> ScaleType.MOTION, (m, t) -> m / t));
    public static final ScaleModifier WIDTH_MULTIPLIER = ScaleModifier.register("width_multiplier", (ScaleModifier)new TypedScaleModifier(() -> ScaleType.WIDTH));
    public static final ScaleModifier HEIGHT_MULTIPLIER = ScaleModifier.register("height_multiplier", (ScaleModifier)new TypedScaleModifier(() -> ScaleType.HEIGHT));
    private final float priority;

    public ScaleModifier() {
        this(512.0f);
    }

    public ScaleModifier(float priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(ScaleModifier o) {
        int c = Float.compare(o.getPriority(), this.getPriority());
        return c != 0 ? c : ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, this).compareTo(ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, o));
    }

    public float getPriority() {
        return this.priority;
    }

    public float modifyScale(ScaleData scaleData, float modifiedScale, float delta) {
        return modifiedScale;
    }

    public float modifyPrevScale(ScaleData scaleData, float modifiedScale) {
        return modifiedScale;
    }

    private static ScaleModifier register(String path, ScaleModifier scaleModifier) {
        return ScaleModifier.register(Pehkui.id(path), scaleModifier);
    }

    private static ScaleModifier register(ResourceLocation id, ScaleModifier scaleModifier) {
        return ScaleRegistries.register(ScaleRegistries.SCALE_MODIFIERS, id, scaleModifier);
    }

    private static ScaleModifier register(ResourceLocation id) {
        return ScaleModifier.register(id, new ScaleModifier());
    }
}

