/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public class ScaleData {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static final ScaleData IDENTITY = Builder.create().buildImmutable(1.0f);
    private float baseScale;
    private float prevBaseScale;
    private float initialScale;
    private float targetScale;
    private int scaleTicks;
    private int totalScaleTicks;
    private Boolean persistent = null;
    private boolean shouldSync = false;
    private final ScaleType scaleType;
    @Nullable
    private final Entity entity;
    private final SortedSet<ScaleModifier> baseValueModifiers = new ObjectAVLTreeSet();
    private final List<ScaleModifier> syncedModifiers = new ArrayList<ScaleModifier>();

    @ApiStatus.Internal
    protected ScaleData(ScaleType scaleType, @Nullable Entity entity) {
        float defaultBaseScale;
        this.scaleType = scaleType;
        this.entity = entity;
        this.baseScale = defaultBaseScale = scaleType.getDefaultBaseScale();
        this.prevBaseScale = defaultBaseScale;
        this.initialScale = defaultBaseScale;
        this.targetScale = defaultBaseScale;
        this.scaleTicks = 0;
        this.totalScaleTicks = scaleType.getDefaultTickDelay();
        this.persistent = scaleType.isPersistent();
        this.getBaseValueModifiers().addAll(this.getScaleType().getDefaultBaseValueModifiers());
    }

    public void tick() {
        float targetScale;
        float currScale = this.getBaseScale();
        if (currScale != (targetScale = this.getTargetScale())) {
            int scaleTickDelay = this.getScaleTickDelay();
            if (this.scaleTicks >= scaleTickDelay) {
                this.initialScale = targetScale;
                this.scaleTicks = 0;
                this.setBaseScale(targetScale);
            } else {
                ++this.scaleTicks;
                float nextScale = currScale + (targetScale - this.initialScale) / (float)scaleTickDelay;
                this.setBaseScale(nextScale);
            }
        } else {
            if (this.prevBaseScale != currScale) {
                this.prevBaseScale = currScale;
            }
            if (this.initialScale != targetScale) {
                this.initialScale = targetScale;
            }
        }
    }

    public ScaleType getScaleType() {
        return this.scaleType;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    public SortedSet<ScaleModifier> getBaseValueModifiers() {
        return this.baseValueModifiers;
    }

    @Deprecated
    protected float computeScale(float value, Collection<ScaleModifier> modifiers, float delta) {
        for (ScaleModifier m : modifiers) {
            value = m.modifyScale(this, value, delta);
        }
        return value;
    }

    public float getBaseScale() {
        return this.getBaseScale(1.0f);
    }

    public float getBaseScale(float delta) {
        return delta == 1.0f ? this.baseScale : MathHelper.func_219799_g((float)delta, (float)this.getPrevBaseScale(), (float)this.baseScale);
    }

    public void setBaseScale(float scale) {
        scale = (float)this.getScaleType().clampBaseScale(this, scale);
        this.prevBaseScale = this.getBaseScale();
        this.baseScale = scale;
        this.onUpdate();
    }

    public float getScale() {
        return this.getScale(1.0f);
    }

    public float getScale(float delta) {
        float value = this.getBaseScale(delta);
        for (ScaleModifier m : this.getBaseValueModifiers()) {
            value = m.modifyScale(this, value, delta);
        }
        return value;
    }

    public void setScale(float scale) {
        this.setBaseScale(scale);
        this.setTargetScale(scale);
    }

    public float getInitialScale() {
        return this.initialScale;
    }

    public float getTargetScale() {
        return this.targetScale;
    }

    public void setTargetScale(float targetScale) {
        targetScale = (float)this.getScaleType().clampTargetScale(this, targetScale);
        this.initialScale = this.getBaseScale();
        this.targetScale = targetScale;
        this.scaleTicks = 0;
        this.markForSync(true);
    }

    public int getScaleTickDelay() {
        return this.totalScaleTicks;
    }

    public void setScaleTickDelay(int ticks) {
        this.totalScaleTicks = ticks;
        this.markForSync(true);
    }

    public float getPrevScale() {
        float value = this.getPrevBaseScale();
        for (ScaleModifier m : this.getBaseValueModifiers()) {
            value = m.modifyPrevScale(this, value);
        }
        return value;
    }

    public float getPrevBaseScale() {
        return this.prevBaseScale;
    }

    public void setPersistence(@Nullable Boolean persistent) {
        this.persistent = persistent;
    }

    @Nullable
    public Boolean getPersistence() {
        return this.persistent;
    }

    public boolean shouldPersist() {
        return this.persistent == null ? this.getScaleType().isPersistent() : this.persistent.booleanValue();
    }

    public void markForSync(boolean sync) {
        Entity e = this.getEntity();
        if (e != null && e.field_70170_p != null && !e.field_70170_p.field_72995_K) {
            this.shouldSync = sync;
        }
    }

    public boolean shouldSync() {
        return this.shouldSync;
    }

    public void onUpdate() {
        this.markForSync(true);
        this.getScaleType().getScaleChangedEvent().forEach(s -> s.onEvent(this));
    }

    public PacketBuffer toPacket(PacketBuffer buffer) {
        this.syncedModifiers.clear();
        this.syncedModifiers.addAll(this.getBaseValueModifiers());
        this.syncedModifiers.removeAll(this.getScaleType().getDefaultBaseValueModifiers());
        buffer.writeFloat(this.baseScale).writeFloat(this.prevBaseScale).writeFloat(this.initialScale).writeFloat(this.targetScale).writeInt(this.scaleTicks).writeInt(this.totalScaleTicks).writeInt(this.syncedModifiers.size());
        for (ScaleModifier modifier : this.syncedModifiers) {
            buffer.func_192572_a(ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, modifier));
        }
        this.syncedModifiers.clear();
        return buffer;
    }

    public void readNbt(CompoundNBT tag) {
        ScaleType type = this.getScaleType();
        this.baseScale = tag.func_74764_b("scale") ? tag.func_74760_g("scale") : type.getDefaultBaseScale();
        this.prevBaseScale = tag.func_74764_b("previous") ? tag.func_74760_g("previous") : this.baseScale;
        this.initialScale = tag.func_74764_b("initial") ? tag.func_74760_g("initial") : this.baseScale;
        this.targetScale = tag.func_74764_b("target") ? tag.func_74760_g("target") : this.baseScale;
        this.scaleTicks = tag.func_74764_b("ticks") ? tag.func_74762_e("ticks") : 0;
        this.totalScaleTicks = tag.func_74764_b("total_ticks") ? tag.func_74762_e("total_ticks") : type.getDefaultTickDelay();
        this.persistent = tag.func_74764_b("persistent") ? Boolean.valueOf(tag.func_74767_n("persistent")) : null;
        SortedSet<ScaleModifier> baseValueModifiers = this.getBaseValueModifiers();
        baseValueModifiers.clear();
        baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
        if (tag.func_74764_b("baseValueModifiers")) {
            ListNBT modifiers = tag.func_150295_c("baseValueModifiers", 8);
            for (int i = 0; i < modifiers.size(); ++i) {
                ResourceLocation id = ResourceLocation.func_208304_a((String)modifiers.func_150307_f(i));
                ScaleModifier modifier = ScaleRegistries.getEntry(ScaleRegistries.SCALE_MODIFIERS, id);
                if (modifier == null) continue;
                baseValueModifiers.add(modifier);
            }
        }
        this.onUpdate();
    }

    public CompoundNBT writeNbt(CompoundNBT tag) {
        Boolean persistent;
        float target;
        float initial;
        ScaleType type = this.getScaleType();
        float defaultBaseScale = type.getDefaultBaseScale();
        float scale = this.getBaseScale();
        if (scale != defaultBaseScale) {
            tag.func_74776_a("scale", scale);
        }
        if ((initial = this.getInitialScale()) != defaultBaseScale) {
            tag.func_74776_a("initial", initial);
        }
        if ((target = this.getTargetScale()) != defaultBaseScale) {
            tag.func_74776_a("target", target);
        }
        if (this.scaleTicks != 0) {
            tag.func_74768_a("ticks", this.scaleTicks);
        }
        if (this.totalScaleTicks != type.getDefaultTickDelay()) {
            tag.func_74768_a("total_ticks", this.totalScaleTicks);
        }
        if ((persistent = this.getPersistence()) != null) {
            tag.func_74757_a("persistent", persistent.booleanValue());
        }
        ArrayList<ScaleModifier> savedModifiers = new ArrayList<ScaleModifier>();
        savedModifiers.addAll(this.getBaseValueModifiers());
        savedModifiers.removeAll(this.getScaleType().getDefaultBaseValueModifiers());
        if (!savedModifiers.isEmpty()) {
            ListNBT modifiers = new ListNBT();
            for (ScaleModifier modifier : savedModifiers) {
                modifiers.add((Object)NBTDynamicOps.field_210820_a.createString(ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, modifier).toString()));
            }
            tag.func_218657_a("baseValueModifiers", (INBT)modifiers);
        }
        return tag;
    }

    public ScaleData resetScale() {
        return this.resetScale(true);
    }

    public ScaleData resetScale(boolean notifyListener) {
        float defaultBaseScale;
        ScaleType type = this.getScaleType();
        this.baseScale = defaultBaseScale = type.getDefaultBaseScale();
        this.prevBaseScale = defaultBaseScale;
        this.initialScale = defaultBaseScale;
        this.targetScale = defaultBaseScale;
        this.scaleTicks = 0;
        this.totalScaleTicks = type.getDefaultTickDelay();
        this.persistent = null;
        SortedSet<ScaleModifier> baseValueModifiers = this.getBaseValueModifiers();
        baseValueModifiers.clear();
        baseValueModifiers.addAll(type.getDefaultBaseValueModifiers());
        if (notifyListener) {
            this.onUpdate();
        }
        return this;
    }

    public boolean isReset() {
        ScaleType type = this.getScaleType();
        float defaultBaseScale = type.getDefaultBaseScale();
        if (this.getBaseScale() != defaultBaseScale) {
            return false;
        }
        if (this.prevBaseScale != defaultBaseScale) {
            return false;
        }
        if (this.getInitialScale() != defaultBaseScale) {
            return false;
        }
        if (this.getTargetScale() != defaultBaseScale) {
            return false;
        }
        if (this.scaleTicks != 0) {
            return false;
        }
        if (this.getScaleTickDelay() != type.getDefaultTickDelay()) {
            return false;
        }
        if (!this.getBaseValueModifiers().equals(this.getScaleType().getDefaultBaseValueModifiers())) {
            return false;
        }
        return this.getPersistence() == null;
    }

    public ScaleData fromScale(ScaleData scaleData) {
        return this.fromScale(scaleData, true);
    }

    public ScaleData fromScale(ScaleData scaleData, boolean notifyListener) {
        this.baseScale = scaleData.getBaseScale();
        this.prevBaseScale = scaleData.getPrevBaseScale();
        this.initialScale = scaleData.getInitialScale();
        this.targetScale = scaleData.getTargetScale();
        this.scaleTicks = scaleData.scaleTicks;
        this.totalScaleTicks = scaleData.totalScaleTicks;
        this.persistent = scaleData.getPersistence();
        if (notifyListener) {
            this.onUpdate();
        }
        return this;
    }

    public ScaleData averagedFromScales(ScaleData scaleData, ScaleData ... scales) {
        float scale = scaleData.getBaseScale();
        float prevScale = scaleData.prevBaseScale;
        float fromScale = scaleData.getInitialScale();
        float toScale = scaleData.getTargetScale();
        int scaleTicks = scaleData.scaleTicks;
        int totalScaleTicks = scaleData.totalScaleTicks;
        for (ScaleData data : scales) {
            scale += data.getBaseScale();
            prevScale += data.prevBaseScale;
            fromScale += data.getInitialScale();
            toScale += data.getTargetScale();
            scaleTicks += data.scaleTicks;
            totalScaleTicks += data.totalScaleTicks;
        }
        float count = scales.length + 1;
        this.baseScale = scale / count;
        this.prevBaseScale = prevScale / count;
        this.initialScale = fromScale / count;
        this.targetScale = toScale / count;
        this.scaleTicks = Math.round((float)scaleTicks / count);
        this.totalScaleTicks = Math.round((float)totalScaleTicks / count);
        this.onUpdate();
        return this;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.initialScale), Float.valueOf(this.prevBaseScale), Float.valueOf(this.baseScale), this.scaleTicks, Float.valueOf(this.targetScale), this.totalScaleTicks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScaleData)) {
            return false;
        }
        return this.equals((ScaleData)obj);
    }

    public boolean equals(ScaleData other) {
        if (this == other) {
            return true;
        }
        return Float.floatToIntBits(this.baseScale) == Float.floatToIntBits(other.baseScale) && Float.floatToIntBits(this.prevBaseScale) == Float.floatToIntBits(other.prevBaseScale) && Float.floatToIntBits(this.initialScale) == Float.floatToIntBits(other.initialScale) && Float.floatToIntBits(this.targetScale) == Float.floatToIntBits(other.targetScale) && this.scaleTicks == other.scaleTicks && this.totalScaleTicks == other.totalScaleTicks && Float.floatToIntBits(this.getScale()) == Float.floatToIntBits(other.getScale());
    }

    public static class Builder {
        private Entity entity = null;
        private ScaleType type = ScaleType.INVALID;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder type(ScaleType type) {
            this.type = type == null ? ScaleType.INVALID : type;
            return this;
        }

        public Builder entity(@Nullable Entity entity) {
            this.entity = entity;
            return this;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
        public ImmutableScaleData buildImmutable(float value) {
            return new ImmutableScaleData(value, this.type, this.entity);
        }

        public ScaleData build() {
            ScaleData existing = this.entity == null ? null : this.type.getScaleData(this.entity);
            return existing != null ? existing : new ScaleData(this.type, this.entity);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0")
    public static class ImmutableScaleData
    extends ScaleData {
        protected ImmutableScaleData(float scale, ScaleType scaleType, @Nullable Entity entity) {
            super(scaleType, entity);
        }

        @Override
        public void tick() {
        }

        @Override
        public float getScale(float delta) {
            return this.getBaseScale(delta);
        }

        @Override
        public void setBaseScale(float scale) {
        }

        @Override
        public float getPrevScale() {
            return this.getPrevBaseScale();
        }

        @Override
        public void setTargetScale(float targetScale) {
        }

        @Override
        public void setScaleTickDelay(int ticks) {
        }

        @Override
        public void markForSync(boolean sync) {
        }

        @Override
        public void onUpdate() {
        }

        @Override
        public void readNbt(CompoundNBT tag) {
        }

        @Override
        public ScaleData resetScale(boolean notifyListener) {
            return this;
        }

        @Override
        public void setPersistence(Boolean persistent) {
        }

        @Override
        public boolean isReset() {
            return true;
        }

        @Override
        public ScaleData fromScale(ScaleData scaleData, boolean notifyListener) {
            return this;
        }
    }
}

