/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.util.ClampingScaleModifier;

public class PehkuiConfig {
    @ApiStatus.Internal
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    @ApiStatus.Internal
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    @ApiStatus.Internal
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    @ApiStatus.Internal
    public static void onLoad(ModConfig.Loading configEvent) {
        LogManager.getLogger().debug(LogMarkers.FORGEMOD, "Loaded Pehkui config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    @ApiStatus.Internal
    public static void onFileChange(ModConfig.Reloading configEvent) {
        LogManager.getLogger().debug(LogMarkers.FORGEMOD, "Pehkui config just got changed on the file system!");
    }

    @SafeVarargs
    private static <E> ArrayList<E> path(E ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.DoubleValue minimumCameraDepth;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings, mostly things related to rendering").push("client");
            this.minimumCameraDepth = builder.translation("pehkui.configgui.minimumCameraDepth").defineInRange("minimumCameraDepth", 0.0, 0.0, 0.05);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue scaledFallDamage;
        public final ForgeConfigSpec.BooleanValue scaledMotion;
        public final ForgeConfigSpec.BooleanValue scaledReach;
        public final ForgeConfigSpec.BooleanValue scaledAttack;
        public final ForgeConfigSpec.BooleanValue scaledDefense;
        public final ForgeConfigSpec.BooleanValue scaledHealth;
        public final ForgeConfigSpec.BooleanValue scaledItemDrops;
        public final ForgeConfigSpec.BooleanValue scaledProjectiles;
        public final ForgeConfigSpec.BooleanValue scaledExplosions;
        public final ForgeConfigSpec.BooleanValue keepAllScalesOnRespawn;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> scalesKeptOnRespawn;
        public final ForgeConfigSpec.BooleanValue accurateNetherPortals;
        public final ForgeConfigSpec.DoubleValue largeScaleCollisionThreshold;
        public final ForgeConfigSpec.BooleanValue enableDebugCommands;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General configuration settings").push("general");
            this.scaledFallDamage = builder.translation("pehkui.configgui.scaledFallDamage").define("scaledFallDamage", true);
            this.scaledMotion = builder.translation("pehkui.configgui.scaledMotion").define("scaledMotion", true);
            this.scaledReach = builder.translation("pehkui.configgui.scaledReach").define("scaledReach", true);
            this.scaledAttack = builder.translation("pehkui.configgui.scaledAttack").define("scaledAttack", true);
            this.scaledDefense = builder.translation("pehkui.configgui.scaledDefense").define("scaledDefense", true);
            this.scaledHealth = builder.translation("pehkui.configgui.scaledHealth").define("scaledHealth", true);
            this.scaledItemDrops = builder.translation("pehkui.configgui.scaledItemDrops").define("scaledItemDrops", true);
            this.scaledProjectiles = builder.translation("pehkui.configgui.scaledProjectiles").define("scaledProjectiles", true);
            this.scaledExplosions = builder.translation("pehkui.configgui.scaledExplosions").define("scaledExplosions", true);
            this.keepAllScalesOnRespawn = builder.translation("pehkui.configgui.keepAllScalesOnRespawn").define("keepAllScalesOnRespawn", false);
            this.accurateNetherPortals = builder.translation("pehkui.configgui.accurateNetherPortals").define("accurateNetherPortals", true);
            this.scalesKeptOnRespawn = builder.translation("pehkui.configgui.scalesKeptOnRespawn").defineListAllowEmpty((List)PehkuiConfig.path(new String[]{"scalesKeptOnRespawn"}), ArrayList::new, s -> {
                try {
                    ResourceLocation id = new ResourceLocation(String.valueOf(s));
                    ScaleType scaleType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, id);
                    ResourceLocation defaultId = ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_TYPES);
                    ScaleType defaultType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, defaultId);
                    return scaleType != null && (scaleType != defaultType || id.equals((Object)defaultId));
                }
                catch (ResourceLocationException e) {
                    return false;
                }
            });
            this.largeScaleCollisionThreshold = builder.translation("pehkui.configgui.largeScaleCollisionThreshold").defineInRange("largeScaleCollisionThreshold", 26.0, 16.0, 128.0);
            this.enableDebugCommands = builder.translation("pehkui.configgui.enableDebugCommands").define("enableDebugCommands", false);
            builder.push("scale_limits");
            for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
                ScaleType type;
                ResourceLocation id = (ResourceLocation)entry.getKey();
                String namespace = id.func_110624_b();
                if (!namespace.equals("pehkui") || (type = (ScaleType)entry.getValue()) == ScaleType.INVALID) continue;
                String path = id.func_110623_a();
                builder.push(path);
                ForgeConfigSpec.DoubleValue min = builder.translation("pehkui.configgui.scale_limits." + path + ".minimum").defineInRange("minimum", (double)1.4E-45f, (double)1.4E-45f, 3.4028234663852886E38);
                ForgeConfigSpec.DoubleValue max = builder.translation("pehkui.configgui.scale_limits." + path + ".maximum").defineInRange("maximum", 3.4028234663852886E38, (double)1.4E-45f, 3.4028234663852886E38);
                type.getDefaultBaseValueModifiers().add(ScaleRegistries.register(ScaleRegistries.SCALE_MODIFIERS, Pehkui.id("clamping", path), new ClampingScaleModifier(() -> ((ForgeConfigSpec.DoubleValue)min).get(), () -> ((ForgeConfigSpec.DoubleValue)max).get(), 0.0f)));
                builder.pop();
            }
            builder.pop();
            builder.pop();
        }
    }

    public static class Server {
        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            builder.pop();
        }
    }
}

