/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui;

import com.mojang.brigadier.CommandDispatcher;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.command.PehkuiEntitySelectorOptions;
import virtuoel.pehkui.command.argument.ScaleModifierArgumentType;
import virtuoel.pehkui.command.argument.ScaleOperationArgumentType;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.network.PehkuiPacketHandler;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.server.command.ScaleCommand;
import virtuoel.pehkui.util.ScaleUtils;

@Mod(value="pehkui")
public class Pehkui {
    public static final String MOD_ID = "pehkui";
    public static final Logger LOGGER = LogManager.getLogger((String)"pehkui");
    public static final UUID REACH_MODIFIER = UUID.fromString("d82ebc57-0753-43e5-95b5-895dc1071e12");
    public static final ResourceLocation SCALE_PACKET = Pehkui.id("scale");

    public Pehkui() {
        ScaleType.INVALID.getClass();
        ScaleType.REACH.getPostTickEvent().add(s -> {
            ModifiableAttributeInstance attribute;
            Entity e = s.getEntity();
            if (e instanceof PlayerEntity && !e.field_70170_p.field_72995_K && (attribute = ((PlayerEntity)e).func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
                double scale = (double)ScaleUtils.getReachScale(e) - 1.0;
                AttributeModifier modifier = attribute.func_111127_a(REACH_MODIFIER);
                if (modifier == null || Double.compare(scale, modifier.func_111164_d()) != 0) {
                    if (modifier != null) {
                        attribute.func_188479_b(REACH_MODIFIER);
                    }
                    if (Double.compare(scale, 0.0) != 0) {
                        attribute.func_233769_c_(new AttributeModifier(REACH_MODIFIER, "Reach Scale", scale, AttributeModifier.Operation.MULTIPLY_BASE));
                    }
                }
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(PehkuiConfig.class);
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.registerConfig(ModConfig.Type.CLIENT, PehkuiConfig.clientSpec);
        ctx.registerConfig(ModConfig.Type.SERVER, PehkuiConfig.serverSpec);
        ctx.registerConfig(ModConfig.Type.COMMON, PehkuiConfig.commonSpec);
        ArgumentTypes.func_218136_a((String)Pehkui.id("scale_type").toString(), ScaleTypeArgumentType.class, (IArgumentSerializer)new ArgumentSerializer(ScaleTypeArgumentType::scaleType));
        ArgumentTypes.func_218136_a((String)Pehkui.id("scale_modifier").toString(), ScaleModifierArgumentType.class, (IArgumentSerializer)new ArgumentSerializer(ScaleModifierArgumentType::scaleModifier));
        ArgumentTypes.func_218136_a((String)Pehkui.id("scale_operation").toString(), ScaleOperationArgumentType.class, (IArgumentSerializer)new ArgumentSerializer(ScaleOperationArgumentType::operation));
        PehkuiEntitySelectorOptions.register();
        PehkuiPacketHandler.init();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ScaleCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        DebugCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation id(String path, String ... paths) {
        return Pehkui.id(paths.length == 0 ? path : path + "/" + String.join((CharSequence)"/", paths));
    }
}

