/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import appeng.parts.p2p.P2PModels;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemP2PTunnelPart
extends CapabilityP2PTunnelPart<ItemP2PTunnelPart, IItemHandler> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_items");
    private static final IItemHandler NULL_ITEM_HANDLER = new NullItemHandler();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public ItemP2PTunnelPart(ItemStack is) {
        super(is, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        this.inputHandler = new InputItemHandler();
        this.outputHandler = new OutputItemHandler();
        this.emptyHandler = NULL_ITEM_HANDLER;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private static class NullItemHandler
    implements IItemHandler {
        private NullItemHandler() {
        }

        public int getSlots() {
            return 0;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    }

    private class OutputItemHandler
    implements IItemHandler {
        private OutputItemHandler() {
        }

        public int getSlots() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ItemP2PTunnelPart.this.getInputCapability();){
                int n = ((IItemHandler)input.get()).getSlots();
                return n;
            }
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ItemP2PTunnelPart.this.getInputCapability();){
                ItemStack itemStack = ((IItemHandler)input.get()).getStackInSlot(slot);
                return itemStack;
            }
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ItemP2PTunnelPart.this.getInputCapability();){
                ItemStack result = ((IItemHandler)input.get()).extractItem(slot, amount, simulate);
                if (!simulate) {
                    ItemP2PTunnelPart.this.queueTunnelDrain(PowerUnits.RF, result.func_190916_E());
                }
                ItemStack itemStack = result;
                return itemStack;
            }
        }

        public int getSlotLimit(int slot) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ItemP2PTunnelPart.this.getInputCapability();){
                int n = ((IItemHandler)input.get()).getSlotLimit(slot);
                return n;
            }
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = ItemP2PTunnelPart.this.getInputCapability();){
                boolean bl = ((IItemHandler)input.get()).isItemValid(slot, stack);
                return bl;
            }
        }
    }

    private class InputItemHandler
    implements IItemHandler {
        private InputItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int remainder = stack.func_190916_E();
            try {
                int outputTunnels = ItemP2PTunnelPart.this.getOutputs().size();
                int amount = stack.func_190916_E();
                if (outputTunnels == 0 || amount == 0) {
                    return stack;
                }
                int amountPerOutput = Math.max(1, amount / outputTunnels);
                int overflow = amountPerOutput == 0 ? amount : amount % amountPerOutput;
                for (ItemP2PTunnelPart target : ItemP2PTunnelPart.this.getOutputs()) {
                    CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                    Throwable throwable = null;
                    try {
                        IItemHandler output = (IItemHandler)capabilityGuard.get();
                        int toSend = amountPerOutput + overflow;
                        if (toSend <= 0) break;
                        ItemStack stackCopy = stack.func_77946_l();
                        stackCopy.func_190920_e(toSend);
                        int sent = toSend - ItemHandlerHelper.insertItem((IItemHandler)output, (ItemStack)stackCopy, (boolean)simulate).func_190916_E();
                        overflow = toSend - sent;
                        remainder -= sent;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (capabilityGuard == null) continue;
                        if (throwable != null) {
                            try {
                                capabilityGuard.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        capabilityGuard.close();
                    }
                }
                if (!simulate) {
                    ItemP2PTunnelPart.this.queueTunnelDrain(PowerUnits.RF, amount - remainder);
                }
            }
            catch (GridAccessException outputTunnels) {
                // empty catch block
            }
            if (remainder == stack.func_190916_E()) {
                return stack;
            }
            if (remainder == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(remainder);
            return copy;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

