/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import appeng.parts.p2p.P2PModels;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidP2PTunnelPart
extends CapabilityP2PTunnelPart<FluidP2PTunnelPart, IFluidHandler> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_fluids");
    private static final IFluidHandler NULL_FLUID_HANDLER = new NullFluidHandler();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FluidP2PTunnelPart(ItemStack is) {
        super(is, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        this.inputHandler = new InputFluidHandler();
        this.outputHandler = new OutputFluidHandler();
        this.emptyHandler = NULL_FLUID_HANDLER;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private static class NullFluidHandler
    implements IFluidHandler {
        private NullFluidHandler() {
        }

        public int getTanks() {
            return 0;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private class OutputFluidHandler
    implements IFluidHandler {
        private OutputFluidHandler() {
        }

        public int getTanks() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FluidP2PTunnelPart.this.getInputCapability();){
                int n = ((IFluidHandler)input.get()).getTanks();
                return n;
            }
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FluidP2PTunnelPart.this.getInputCapability();){
                FluidStack fluidStack = ((IFluidHandler)input.get()).getFluidInTank(tank);
                return fluidStack;
            }
        }

        public int getTankCapacity(int tank) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FluidP2PTunnelPart.this.getInputCapability();){
                int n = ((IFluidHandler)input.get()).getTankCapacity(tank);
                return n;
            }
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FluidP2PTunnelPart.this.getInputCapability();){
                boolean bl = ((IFluidHandler)input.get()).isFluidValid(tank, stack);
                return bl;
            }
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FluidP2PTunnelPart.this.getInputCapability();){
                FluidStack result = ((IFluidHandler)input.get()).drain(resource, action);
                if (action.execute()) {
                    FluidP2PTunnelPart.this.queueTunnelDrain(PowerUnits.RF, result.getAmount());
                }
                FluidStack fluidStack = result;
                return fluidStack;
            }
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FluidP2PTunnelPart.this.getInputCapability();){
                FluidStack result = ((IFluidHandler)input.get()).drain(maxDrain, action);
                if (action.execute()) {
                    FluidP2PTunnelPart.this.queueTunnelDrain(PowerUnits.RF, result.getAmount());
                }
                FluidStack fluidStack = result;
                return fluidStack;
            }
        }
    }

    private class InputFluidHandler
    implements IFluidHandler {
        private InputFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int total = 0;
            try {
                int outputTunnels = FluidP2PTunnelPart.this.getOutputs().size();
                int amount = resource.getAmount();
                if (outputTunnels == 0 || amount == 0) {
                    return 0;
                }
                int amountPerOutput = Math.max(1, amount / outputTunnels);
                int overflow = amountPerOutput == 0 ? amount : amount % amountPerOutput;
                for (FluidP2PTunnelPart target : FluidP2PTunnelPart.this.getOutputs()) {
                    CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                    Throwable throwable = null;
                    try {
                        IFluidHandler output = (IFluidHandler)capabilityGuard.get();
                        int toSend = amountPerOutput + overflow;
                        FluidStack fillWithFluidStack = resource.copy();
                        fillWithFluidStack.setAmount(toSend);
                        int received = output.fill(fillWithFluidStack, action);
                        overflow = toSend - received;
                        total += received;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (capabilityGuard == null) continue;
                        if (throwable != null) {
                            try {
                                capabilityGuard.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        capabilityGuard.close();
                    }
                }
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    FluidP2PTunnelPart.this.queueTunnelDrain(PowerUnits.RF, total);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return total;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

