/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.api.storage.data.IAEStack;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.container.me.common.GridInventoryEntry;
import appeng.container.me.common.IClientRepo;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.integration.abstraction.JEIFacade;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Repo<T extends IAEStack<T>>
implements IClientRepo<T> {
    private int rowSize = 9;
    private String searchString = "";
    private boolean hasPower;
    private final BiMap<Long, GridInventoryEntry<T>> entries = HashBiMap.create();
    private final ArrayList<GridInventoryEntry<T>> view = new ArrayList();
    private IPartitionList<T> partitionList;
    private Runnable updateViewListener;
    private final IScrollSource src;
    private final ISortSource sortSrc;
    private boolean synchronizeWithJEI;

    public Repo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public void setPartitionList(IPartitionList<T> partitionList) {
        if (partitionList != this.partitionList) {
            this.partitionList = partitionList;
            this.updateView();
        }
    }

    @Override
    public final void handleUpdate(boolean fullUpdate, List<GridInventoryEntry<T>> entries) {
        if (fullUpdate) {
            this.clear();
        }
        for (GridInventoryEntry<T> entry : entries) {
            this.handleUpdate(entry);
        }
        this.updateView();
    }

    private void handleUpdate(GridInventoryEntry<T> serverEntry) {
        GridInventoryEntry localEntry = (GridInventoryEntry)this.entries.get((Object)serverEntry.getSerial());
        if (localEntry == null) {
            if (serverEntry.getStack() == null) {
                AELog.warn("First time seeing serial %s, but incomplete info received", serverEntry.getSerial());
                return;
            }
            if (serverEntry.isMeaningful()) {
                this.entries.put((Object)serverEntry.getSerial(), serverEntry);
            }
            return;
        }
        if (!serverEntry.isMeaningful()) {
            this.entries.remove((Object)serverEntry.getSerial());
        } else if (serverEntry.getStack() == null) {
            this.entries.put((Object)serverEntry.getSerial(), new GridInventoryEntry(serverEntry.getSerial(), localEntry.getStack(), serverEntry.getStoredAmount(), serverEntry.getRequestableAmount(), serverEntry.isCraftable()));
        } else {
            this.entries.put((Object)serverEntry.getSerial(), serverEntry);
        }
    }

    public final void updateView() {
        Pattern m;
        String innerSearch;
        this.view.clear();
        this.view.ensureCapacity(this.entries.size());
        this.updateJEI(this.searchString);
        SearchMode searchMode = SearchMode.NAME;
        if (AEConfig.instance().getSearchTooltips() != YesNo.NO) {
            searchMode = SearchMode.NAME_OR_TOOLTIP;
        }
        if ((innerSearch = this.searchString).startsWith("@")) {
            searchMode = SearchMode.MOD;
            innerSearch = innerSearch.substring(1);
        }
        try {
            m = Pattern.compile(innerSearch.toLowerCase(), 2);
        }
        catch (PatternSyntaxException ignored) {
            m = Pattern.compile(Pattern.quote(innerSearch.toLowerCase()), 2);
        }
        ViewItems viewMode = this.sortSrc.getSortDisplay();
        for (GridInventoryEntry entry : this.entries.values()) {
            if (this.partitionList != null && !this.partitionList.isListed(entry.getStack()) || viewMode == ViewItems.CRAFTABLE && !entry.isCraftable() || viewMode == ViewItems.STORED && entry.getStoredAmount() == 0L || !this.matchesSearch(searchMode, m, entry.getStack())) continue;
            this.view.add(entry);
        }
        SortOrder sortOrder = this.sortSrc.getSortBy();
        SortDir sortDir = this.sortSrc.getSortDir();
        this.view.sort(Comparator.comparing(GridInventoryEntry::getStack, this.getComparator(sortOrder, sortDir)));
        if (this.updateViewListener != null) {
            this.updateViewListener.run();
        }
    }

    @Nullable
    public final GridInventoryEntry<T> get(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    public final int size() {
        return this.view.size();
    }

    public final void clear() {
        this.entries.clear();
        this.view.clear();
    }

    public final boolean hasPower() {
        return this.hasPower;
    }

    public final void setPower(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public final int getRowSize() {
        return this.rowSize;
    }

    public final void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public final String getSearchString() {
        return this.searchString;
    }

    public final void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }

    private void updateJEI(String filter) {
        SearchBoxMode searchMode = AEConfig.instance().getTerminalSearchMode();
        if (this.synchronizeWithJEI && searchMode.isRequiresJei()) {
            JEIFacade.instance().setSearchText(filter);
        }
    }

    protected final void setSynchronizeWithJEI(boolean enable) {
        this.synchronizeWithJEI = enable;
    }

    protected abstract boolean matchesSearch(SearchMode var1, Pattern var2, T var3);

    protected abstract Comparator<? super T> getComparator(SortOrder var1, SortDir var2);

    @Override
    public Set<GridInventoryEntry<T>> getAllEntries() {
        return this.entries.values();
    }

    public final void setUpdateViewListener(Runnable updateViewListener) {
        this.updateViewListener = updateViewListener;
    }

    protected static enum SearchMode {
        MOD,
        NAME,
        NAME_OR_TOOLTIP;

    }
}

