/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.network.packet.SwingArmPacket;

public class OffhandCooldownTracker
implements ICapabilityProvider {
    public static final ResourceLocation KEY = Mantle.getResource("offhand_cooldown");
    private static final NonNullFunction<OffhandCooldownTracker, Float> COOLDOWN_TRACKER = OffhandCooldownTracker::getCooldown;
    private static final NonNullFunction<OffhandCooldownTracker, Boolean> ATTACK_READY = OffhandCooldownTracker::isAttackReady;
    @CapabilityInject(value=OffhandCooldownTracker.class)
    public static Capability<OffhandCooldownTracker> CAPABILITY = null;
    private final LazyOptional<OffhandCooldownTracker> capabilityInstance = LazyOptional.of(() -> this);
    @Nullable
    private final PlayerEntity player;
    private int lastCooldown = 0;
    private int attackReady = 0;

    public static void register() {
        CapabilityManager.INSTANCE.register(OffhandCooldownTracker.class, (Capability.IStorage)new Capability.IStorage<OffhandCooldownTracker>(){

            @Nullable
            public INBT writeNBT(Capability<OffhandCooldownTracker> capability, OffhandCooldownTracker instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<OffhandCooldownTracker> capability, OffhandCooldownTracker instance, Direction side, INBT nbt) {
            }
        }, () -> new OffhandCooldownTracker(null));
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, OffhandCooldownTracker::attachCapability);
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(KEY, (ICapabilityProvider)new OffhandCooldownTracker((PlayerEntity)entity));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == CAPABILITY ? this.capabilityInstance.cast() : LazyOptional.empty();
    }

    private int getTicksExisted() {
        if (this.player == null) {
            return 0;
        }
        return this.player.field_70173_aa;
    }

    public void applyCooldown(int cooldown) {
        this.lastCooldown = cooldown;
        this.attackReady = this.getTicksExisted() + cooldown;
    }

    public float getCooldown() {
        int ticksExisted = this.getTicksExisted();
        if (ticksExisted > this.attackReady || this.lastCooldown == 0) {
            return 1.0f;
        }
        return MathHelper.func_76131_a((float)((float)(this.lastCooldown + ticksExisted - this.attackReady) / (float)this.lastCooldown), (float)0.0f, (float)1.0f);
    }

    public boolean isAttackReady() {
        return this.getTicksExisted() + this.lastCooldown > this.attackReady;
    }

    public static float getCooldown(PlayerEntity player) {
        return player.getCapability(CAPABILITY).map(COOLDOWN_TRACKER).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public static void applyCooldown(PlayerEntity player, int cooldown) {
        player.getCapability(CAPABILITY).ifPresent(cap -> cap.applyCooldown(cooldown));
    }

    public static boolean isAttackReady(PlayerEntity player) {
        return player.getCapability(CAPABILITY).map(ATTACK_READY).orElse(true);
    }

    public static void applyCooldown(PlayerEntity player, float attackSpeed, int cooldownTime) {
        OffhandCooldownTracker.applyCooldown(player, Math.round((float)cooldownTime / attackSpeed));
    }

    public static void swingHand(LivingEntity entity, Hand hand, boolean updateSelf) {
        if (!entity.field_82175_bq || entity.field_110158_av >= entity.func_82166_i() / 2 || entity.field_110158_av < 0) {
            entity.field_110158_av = -1;
            entity.field_82175_bq = true;
            entity.field_184622_au = hand;
            if (!entity.field_70170_p.field_72995_K) {
                SwingArmPacket packet = new SwingArmPacket((Entity)entity, hand);
                if (updateSelf) {
                    MantleNetwork.INSTANCE.sendToTrackingAndSelf(packet, (Entity)entity);
                } else {
                    MantleNetwork.INSTANCE.sendToTracking(packet, (Entity)entity);
                }
            }
        }
    }

    public OffhandCooldownTracker(@Nullable PlayerEntity player) {
        this.player = player;
    }
}

