/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.gui.GuiMisc;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    private IXaeroMinimap modMain;
    private MatrixStack identityMatrixStack;
    private MatrixStack identityMatrixStackOverlay;
    private Vector4f origin4f;
    private List<Waypoint> sortingList;
    private WaypointFilterParams filterParams;
    private Predicate<Waypoint> filter;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.identityMatrixStack = new MatrixStack();
        this.identityMatrixStackOverlay = new MatrixStack();
        this.origin4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.sortingList = new ArrayList<Waypoint>();
        this.filterParams = new WaypointFilterParams();
        this.filter = w -> {
            float offZ;
            double depth;
            WaypointFilterParams filterParams = this.filterParams;
            boolean deathpoints = filterParams.deathpoints;
            if (w.isDisabled() || w.getType() == 1 && !deathpoints) {
                return false;
            }
            float offX = (float)((double)w.getX(filterParams.dimDiv) - filterParams.cameraX) + 0.5f;
            float offY = (float)((double)w.getY() - filterParams.cameraY) + 1.0f;
            if (!w.isYIncluded()) {
                offY = (float)(filterParams.playerY - filterParams.cameraY) + 1.0f;
            }
            if ((depth = (double)offX * filterParams.lookVector.field_72450_a + (double)offY * filterParams.lookVector.field_72448_b + (double)(offZ = (float)((double)w.getZ(filterParams.dimDiv) - filterParams.cameraZ) + 0.5f) * filterParams.lookVector.field_72449_c) <= 0.1) {
                return false;
            }
            double distance2D = Math.sqrt(offX * offX + offZ * offZ);
            double waypointsDistance = filterParams.waypointsDistance;
            double waypointsDistanceMin = filterParams.waypointsDistanceMin;
            return !(w.getType() == 0 && !w.isGlobal() && waypointsDistance != 0.0 && distance2D > waypointsDistance) && (waypointsDistanceMin == 0.0 || !(distance2D < waypointsDistanceMin));
        };
    }

    public void render(XaeroMinimapSession minimapSession, float partial, MinimapProcessor minimap, Matrix4f waypointsProjection) {
        if (this.modMain.getSettings().getShowIngameWaypoints()) {
            Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
            Vector3d cameraPos;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_BENEFICIAL) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL)) {
                return;
            }
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            FontRenderer fontrenderer = renderManager.func_78716_a();
            if (fontrenderer == null) {
                return;
            }
            MatrixStack matrixStack = this.identityMatrixStack;
            MatrixStack matrixStackOverlay = this.identityMatrixStackOverlay;
            MinimapRendererHelper helper = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper();
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            Entity entity = mc.func_175606_aa();
            ActiveRenderInfo activeRender = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            double actualEntityX = entity.func_226277_ct_();
            double actualEntityY = entity.func_226278_cu_();
            double actualEntityZ = entity.func_226281_cx_();
            double smoothEntityY = minimap.getEntityRadar().getEntityY(entity, partial);
            Waypoint.RENDER_SORTING_POS = cameraPos = activeRender.func_216785_c();
            double d3 = cameraPos.func_82615_a();
            double d4 = cameraPos.func_82617_b();
            double d5 = cameraPos.func_82616_c();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.disableCull();
            matrixStack.func_227860_a_();
            boolean lookingBack = mc.field_71474_y.func_243230_g() == PointOfView.THIRD_PERSON_FRONT;
            float yaw = (float)(lookingBack ? 0 : 180) + entity.func_195046_g(partial);
            float pitch = (float)(lookingBack ? -1 : 1) * entity.func_195050_f(partial);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw));
            RenderHelper.func_227783_c_();
            double fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198109_k();
            int screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198091_l();
            float cameraAngleYaw = MathHelper.func_76142_g((float)(yaw - 180.0f));
            float cameraAnglePitch = MathHelper.func_76142_g((float)pitch);
            Vector3d lookVector = entity.func_70040_Z();
            if (lookingBack) {
                lookVector = lookVector.func_216371_e();
            }
            double clampDepth = this.modMain.getSettings().getWaypointsClampDepth(fov, screenHeight);
            double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
            List<Waypoint> sortingList = this.sortingList;
            sortingList.clear();
            if (waypointsManager.getWaypoints() != null) {
                if (this.modMain.getSettings().renderAllSets) {
                    HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                    for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                        sortingList.addAll(setEntry.getValue().getList());
                    }
                } else {
                    sortingList.addAll(waypointsManager.getWaypoints().getList());
                }
            }
            if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
                for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                    sortingList.addAll(modCustomWaypoints.values());
                }
            }
            matrixStackOverlay.func_227860_a_();
            matrixStackOverlay.func_227861_a_(0.0, 0.0, -2980.0);
            if (!sortingList.isEmpty()) {
                this.filterParams.setParams(d3, d4, d5, lookVector, dimDiv, this.modMain.getSettings().getDeathpoints(), this.modMain.getSettings().getMaxWaypointsDistance(), this.modMain.getSettings().waypointsDistanceMin, smoothEntityY);
                Stream<Waypoint> waypointStream = sortingList.stream().filter(this.filter).sorted();
                IRenderTypeBuffer.Impl cvcRenderTypeBuffer = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
                IVertexBuilder waypointBackgroundConsumer = cvcRenderTypeBuffer.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
                this.renderWaypointsIterator(matrixStack, matrixStackOverlay, helper, waypointStream.iterator(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, cvcRenderTypeBuffer, waypointBackgroundConsumer, fontrenderer, waypointsProjection, screenWidth);
            }
            matrixStackOverlay.func_227865_b_();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderHelper.func_227784_d_();
            RenderHelper.func_74518_a();
            matrixStack.func_227865_b_();
        }
    }

    private void renderWaypointsIterator(MatrixStack matrixStack, MatrixStack matrixStackOverlay, MinimapRendererHelper helper, Iterator<Waypoint> iter, double d3, double d4, double d5, Entity entity, BufferBuilder bufferbuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, float yaw, float pitch, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, Vector3d lookVector, double clampDepth, IRenderTypeBuffer.Impl renderTypeBuffer, IVertexBuilder waypointBackgroundConsumer, FontRenderer fontrenderer, Matrix4f waypointsProjection, int screenWidth) {
        int count = 0;
        while (iter.hasNext()) {
            Waypoint w = iter.next();
            this.renderWaypointIngame(matrixStack, matrixStackOverlay, helper, cameraAngleYaw, cameraAnglePitch, lookVector, w, this.modMain, clampDepth, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, renderTypeBuffer, waypointBackgroundConsumer, fontrenderer, waypointsProjection, screenWidth, screenHeight);
            if (++count >= 19500) continue;
            matrixStackOverlay.func_227861_a_(0.0, 0.0, (double)0.1f);
        }
        renderTypeBuffer.func_228461_a_();
        RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
    }

    private void renderWaypointIngame(MatrixStack matrixStack, MatrixStack matrixStackOverlay, MinimapRendererHelper helper, float cameraAngleYaw, float cameraAnglePitch, Vector3d lookVector, Waypoint w, IXaeroMinimap modMain, double depthClamp, double d3, double d4, double d5, Entity entity, BufferBuilder bufferBuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, IRenderTypeBuffer.Impl textRenderTypeBuffer, IVertexBuilder waypointBackgroundConsumer, FontRenderer fontrenderer, Matrix4f waypointsProjection, int screenWidth, int screenHeight) {
        float offX = (float)((double)w.getX(dimDiv) - d3) + 0.5f;
        float offY = (float)((double)w.getY() - d4) + 1.0f;
        if (!w.isYIncluded()) {
            offY = (float)(smoothEntityY - d4) + 1.0f;
        }
        float offZ = (float)((double)w.getZ(dimDiv) - d5) + 0.5f;
        double depth = (double)offX * lookVector.field_72450_a + (double)offY * lookVector.field_72448_b + (double)offZ * lookVector.field_72449_c;
        double correctOffX = actualEntityX - (double)w.getX() - 0.5;
        double correctOffY = actualEntityY - (double)w.getY();
        if (!w.isYIncluded()) {
            correctOffY = 0.0;
        }
        double correctOffZ = actualEntityZ - (double)w.getZ() - 0.5;
        double correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + correctOffZ * correctOffZ);
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        float originalOffY = offY;
        matrixStack.func_227860_a_();
        matrixStackOverlay.func_227860_a_();
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean showDistance = false;
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                if (offZ < 0.0f) {
                    angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = showDistance = Math.abs(offset = MathHelper.func_76142_g((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float verticalAngle = (float)Math.toDegrees(Math.atan((double)(-originalOffY) / (distance2D == 0.0 ? 1.0E-5 : distance2D)));
                    showDistance = showDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                showDistance = true;
            }
            if (showDistance) {
                distanceText = GuiMisc.simpleFormat.format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        matrixStack.func_227861_a_((double)offX, (double)offY, (double)offZ);
        this.drawAsOverlay(matrixStack, matrixStackOverlay, helper, w, modMain.getSettings(), bufferBuilder, tessellator, fontrenderer, name, distanceText, textSize, showDistance, textRenderTypeBuffer, waypointBackgroundConsumer, waypointsProjection, screenWidth, screenHeight, depthClamp, depth);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227865_b_();
        matrixStackOverlay.func_227865_b_();
    }

    public void drawAsOverlay(MatrixStack matrixStack, MatrixStack matrixStackOverlay, MinimapRendererHelper helper, Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance, IRenderTypeBuffer.Impl renderTypeBuffer, IVertexBuilder waypointBackgroundConsumer, Matrix4f waypointsProjection, int screenWidth, int screenHeight, double depthClamp, double depth) {
        this.origin4f.func_229372_a_(matrixStack.func_227866_c_().func_227870_a_());
        this.origin4f.func_229372_a_(waypointsProjection);
        int overlayPosX = (int)((1.0f + this.origin4f.func_195910_a() / this.origin4f.func_195915_d()) / 2.0f * (float)screenWidth);
        int overlayPosY = (int)((1.0f - this.origin4f.func_195913_b() / this.origin4f.func_195915_d()) / 2.0f * (float)screenHeight);
        this.origin4f.func_195911_a(0.0f, 0.0f, 0.0f, 1.0f);
        matrixStackOverlay.func_227861_a_((double)overlayPosX, (double)overlayPosY, 0.0);
        if (depth < depthClamp) {
            float scale = (float)(depthClamp / depth);
            matrixStackOverlay.func_227862_a_(scale, scale, scale);
        }
        this.drawIconInWorld(matrixStackOverlay, helper, w, settings, vertexBuffer, tessellator, fontrenderer, name, distance, textSize, showDistance, renderTypeBuffer, waypointBackgroundConsumer);
    }

    public void drawIconInWorld(MatrixStack matrixStack, MinimapRendererHelper helper, Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance, IRenderTypeBuffer.Impl renderTypeBuffer, IVertexBuilder waypointBackgroundConsumer) {
        double iconScale = settings.getWaypointsIngameIconScale();
        double distanceScale = settings.getWaypointsIngameDistanceScale();
        double nameScale = settings.getWaypointsIngameNameScale();
        int ingameOpacity = settings.waypointOpacityIngame;
        int addedFrame = 0;
        if (Minecraft.func_71410_x().func_211821_e()) {
            iconScale = (int)((iconScale + 1.0) / 2.0) * 2;
            distanceScale = (int)((distanceScale + 1.0) / 2.0) * 2;
            nameScale = (int)((nameScale + 1.0) / 2.0) * 2;
        }
        int c = ModSettings.COLORS[w.getColor()];
        float red = (float)(c >> 16 & 0xFF) / 255.0f;
        float green = (float)(c >> 8 & 0xFF) / 255.0f;
        float blue = (float)(c & 0xFF) / 255.0f;
        float alpha = 133.3f * ((float)ingameOpacity / 100.0f) / 255.0f;
        int halfIconPixel = (int)iconScale / 2;
        matrixStack.func_227861_a_((double)halfIconPixel, 0.0, 0.0);
        matrixStack.func_227862_a_((float)iconScale, (float)iconScale, 1.0f);
        if (w.getType() == 0) {
            int s = fontrenderer.func_78256_a(w.getSymbol()) / 2;
            addedFrame = this.renderColorBackground(matrixStack, addedFrame, s, red, green, blue, alpha, waypointBackgroundConsumer);
            Misc.drawNormalText(matrixStack, w.getSymbol(), -s, -8.0f, -1, false, renderTypeBuffer);
        } else if (w.getType() == 1) {
            addedFrame = this.renderColorBackground(matrixStack, addedFrame, 4, red, green, blue, alpha, waypointBackgroundConsumer);
            IVertexBuilder guiNearestConsumer = renderTypeBuffer.getBuffer(CustomRenderTypes.GUI_NEAREST);
            this.renderTexturedIcon(matrixStack, addedFrame, 0, 78, 0.9882f, 0.9882f, 0.9882f, 1.0f, guiNearestConsumer);
            if (!showDistance) {
                name = w.getLocalizedName();
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        boolean showingName = name.length() > 0;
        matrixStack.func_227861_a_(0.0, (double)addedFrame, 0.0);
        matrixStack.func_227862_a_((float)(1.0 / iconScale), (float)(1.0 / iconScale), 1.0f);
        matrixStack.func_227861_a_((double)(-halfIconPixel), 0.0, 0.0);
        matrixStack.func_227861_a_(0.0, 2.0, 0.0);
        float labelAlpha = 0.3529412f;
        if (showingName) {
            this.renderWaypointLabel(matrixStack, helper, fontrenderer, name, nameScale, labelAlpha, renderTypeBuffer, waypointBackgroundConsumer);
        }
        matrixStack.func_227861_a_(0.0, 2.0, 0.0);
        if (distance.length() > 0) {
            this.renderWaypointLabel(matrixStack, helper, fontrenderer, distance, distanceScale, labelAlpha, renderTypeBuffer, waypointBackgroundConsumer);
        }
    }

    private void renderWaypointLabel(MatrixStack matrixStack, MinimapRendererHelper helper, FontRenderer fontrenderer, String label, double labelScale, float bgAlpha, IRenderTypeBuffer.Impl renderTypeBuffer, IVertexBuilder waypointBackgroundConsumer) {
        int nameW = fontrenderer.func_78256_a(label);
        int bgW = nameW + 3;
        int halfBgW = bgW / 2;
        int halfNamePixel = 0;
        if ((bgW & 1) != 0) {
            halfNamePixel = (int)labelScale / 2;
            matrixStack.func_227861_a_((double)(-halfNamePixel), 0.0, 0.0);
        }
        matrixStack.func_227862_a_((float)labelScale, (float)labelScale, 1.0f);
        helper.addColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), waypointBackgroundConsumer, -halfBgW, 0.0f, bgW, 9, 0.0f, 0.0f, 0.0f, bgAlpha);
        Misc.drawNormalText(matrixStack, label, -halfBgW + 2, 1.0f, -1, false, renderTypeBuffer);
        matrixStack.func_227861_a_(0.0, 9.0, 0.0);
        matrixStack.func_227862_a_((float)(1.0 / labelScale), (float)(1.0 / labelScale), 1.0f);
        matrixStack.func_227861_a_((double)halfNamePixel, 0.0, 0.0);
        RenderSystem.enableBlend();
    }

    private int renderColorBackground(MatrixStack matrixStack, int addedFrame, int s, float r, float g, float b, float a, IVertexBuilder waypointBackgroundConsumer) {
        if (s > 4) {
            addedFrame = s - 4;
        }
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        waypointBackgroundConsumer.func_227888_a_(matrix, (float)(-5 - addedFrame), (float)(-9 - addedFrame), 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        waypointBackgroundConsumer.func_227888_a_(matrix, (float)(-5 - addedFrame), (float)addedFrame, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        waypointBackgroundConsumer.func_227888_a_(matrix, (float)(4 + addedFrame), (float)addedFrame, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        waypointBackgroundConsumer.func_227888_a_(matrix, (float)(4 + addedFrame), (float)(-9 - addedFrame), 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        return addedFrame;
    }

    private void renderTexturedIcon(MatrixStack matrixStack, int addedFrame, int textureX, int textureY, float r, float g, float b, float a, IVertexBuilder vertexBuffer) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        vertexBuffer.func_227888_a_(matrix, (float)(-5 - addedFrame), (float)(-9 - addedFrame), 0.0f).func_225583_a_((float)textureX * f, (float)textureY * f1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, (float)(-5 - addedFrame), (float)addedFrame, 0.0f).func_225583_a_((float)textureX * f, (float)(textureY + 9 + addedFrame * 2) * f1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, (float)(4 + addedFrame), (float)addedFrame, 0.0f).func_225583_a_((float)(textureX + 9 + addedFrame * 2) * f, (float)(textureY + 9 + addedFrame * 2) * f1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, (float)(4 + addedFrame), (float)(-9 - addedFrame), 0.0f).func_225583_a_((float)(textureX + 9 + addedFrame * 2) * f, (float)textureY * f1).func_227885_a_(r, g, b, a).func_181675_d();
    }
}

