/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;

public class MinimapRendererHelper {
    public void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float factor) {
        this.drawMyTexturedModalRect(x, y, textureX, textureY, width, height, height, factor);
    }

    public void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + height), 0.0).func_225583_a_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_(((float)textureX + width) * f, (float)(textureY + 0) * f1).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + 0.0f), 0.0).func_225583_a_(((float)textureX + width) * f, ((float)textureY + theight) * f1).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_225583_a_((float)(textureX + 0) * f, ((float)textureY + theight) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public void prepareMyTexturedColoredModalRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, float r, float g, float b, float a, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        BufferBuilder vertexBuffer = renderer.begin(7, DefaultVertexFormats.field_181709_i, textureId);
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + height, 0.0f).func_225583_a_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(((float)textureX + width) * f, (float)(textureY + 0) * f1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + 0.0f, 0.0f).func_225583_a_(((float)textureX + width) * f, ((float)textureY + theight) * f1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + 0.0f, 0.0f).func_225583_a_((float)(textureX + 0) * f, ((float)textureY + theight) * f1).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public void prepareMyTexturedModalRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        BufferBuilder vertexBuffer = renderer.begin(7, DefaultVertexFormats.field_181707_g, textureId);
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + height, 0.0f).func_225583_a_((float)(textureX + 0) * f, (float)(textureY + 0) * f1).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(((float)textureX + width) * f, (float)(textureY + 0) * f1).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + width, y + 0.0f, 0.0f).func_225583_a_(((float)textureX + width) * f, ((float)textureY + theight) * f1).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + 0.0f, 0.0f).func_225583_a_((float)(textureX + 0) * f, ((float)textureY + theight) * f1).func_181675_d();
    }

    void drawTexturedElipseInsideRectangle(int sides, float x, float y, int textureX, int textureY, float width, float widthFactor) {
        this.drawTexturedElipseInsideRectangle(sides, x, y, textureX, textureY, width, width, widthFactor);
    }

    void drawTexturedElipseInsideRectangle(int sides, float x, float y, int textureX, int textureY, float width, float theight, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        float halfWidth = width / 2.0f;
        double centerX = x + halfWidth;
        double centerY = y + halfWidth;
        float centerU = ((float)textureX + halfWidth) * f;
        float centerV = (float)(((double)textureY + (double)theight * 0.5) * (double)f1);
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalV = 0.0f;
        vertexBuffer.func_181668_a(4, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i <= sides; ++i) {
            double angle = (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalV = (float)((double)theight * (1.0 - 0.5 * (1.0 - cos)));
            if (i > 0) {
                vertexBuffer.func_225582_a_((double)(x + vertexLocalX), (double)(y + vertexLocalY), 0.0).func_225583_a_(((float)textureX + vertexLocalX) * f, ((float)textureY + vertexLocalV) * f1).func_181675_d();
                vertexBuffer.func_225582_a_((double)(x + prevVertexLocalX), (double)(y + prevVertexLocalY), 0.0).func_225583_a_(((float)textureX + prevVertexLocalX) * f, ((float)textureY + prevVertexLocalV) * f1).func_181675_d();
                vertexBuffer.func_225582_a_(centerX, centerY, 0.0).func_225583_a_(centerU, centerV).func_181675_d();
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalV = vertexLocalV;
        }
        tessellator.func_78381_a();
    }

    void drawTexturedElipseInsideRectangleFrame(int sides, float thickness, float x, float y, int textureX, int textureY, float width, float theight, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        float halfWidth = width / 2.0f;
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalOuterX = 0.0f;
        float prevVertexLocalOuterY = 0.0f;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float sectionOuterWidth = (float)(fullCircle / (double)sides * (double)(halfWidth + thickness));
        float sectionInnerWidth = (float)(fullCircle / (double)sides * (double)halfWidth);
        for (int i = 0; i <= sides; ++i) {
            double angle = (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalOuterX = halfWidth + (float)((double)(halfWidth + thickness) * sin);
            float vertexLocalOuterY = (float)((double)halfWidth - (double)(halfWidth + thickness) * cos);
            if (i > 0) {
                vertexBuffer.func_225582_a_((double)(x + prevVertexLocalX), (double)(y + prevVertexLocalY), 0.0).func_225583_a_((float)textureX * f, ((float)textureY + theight) * f1).func_181675_d();
                vertexBuffer.func_225582_a_((double)(x + vertexLocalX), (double)(y + vertexLocalY), 0.0).func_225583_a_(((float)textureX + sectionInnerWidth) * f, ((float)textureY + theight) * f1).func_181675_d();
                vertexBuffer.func_225582_a_((double)(x + vertexLocalOuterX), (double)(y + vertexLocalOuterY), 0.0).func_225583_a_(((float)textureX + sectionOuterWidth) * f, (float)textureY * f1).func_181675_d();
                vertexBuffer.func_225582_a_((double)(x + prevVertexLocalOuterX), (double)(y + prevVertexLocalOuterY), 0.0).func_225583_a_((float)textureX * f, (float)textureY * f1).func_181675_d();
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalOuterX = vertexLocalOuterX;
            prevVertexLocalOuterY = vertexLocalOuterY;
        }
        tessellator.func_78381_a();
    }

    public void addTexturedRectToExistingBuffer(IVertexBuilder vertexBuffer, float x, float y, int u, int v, int w, int h) {
        float f = 0.00390625f;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + w) * f;
        float normalizedV2 = (float)(v + h) * f;
        vertexBuffer.func_225582_a_((double)x, (double)(y + (float)h), 0.0).func_225583_a_(normalizedU1, normalizedV2).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + (float)w), (double)(y + (float)h), 0.0).func_225583_a_(normalizedU2, normalizedV2).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + (float)w), (double)y, 0.0).func_225583_a_(normalizedU2, normalizedV1).func_181675_d();
        vertexBuffer.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(normalizedU1, normalizedV1).func_181675_d();
    }

    public void addTexturedColoredRectToExistingBuffer(Matrix4f matrix, IVertexBuilder vertexBuffer, float x, float y, int u, int v, int w, int h, float r, float g, float b, float a, float factor) {
        float f = 1.0f / factor;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + w) * f;
        float normalizedV2 = (float)(v + h) * f;
        vertexBuffer.func_227888_a_(matrix, x, y + (float)h, 0.0f).func_225583_a_(normalizedU1, normalizedV1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + (float)w, y + (float)h, 0.0f).func_225583_a_(normalizedU2, normalizedV1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + (float)w, y, 0.0f).func_225583_a_(normalizedU2, normalizedV2).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x, y, 0.0f).func_225583_a_(normalizedU1, normalizedV2).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public void addColoredRectToExistingBuffer(Matrix4f matrix, IVertexBuilder vertexBuffer, float x, float y, int w, int h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.addColoredRectToExistingBuffer(matrix, vertexBuffer, x, y, w, h, r, g, b, a);
    }

    public void addColoredRectToExistingBuffer(Matrix4f matrix, IVertexBuilder vertexBuffer, float x, float y, int w, int h, float r, float g, float b, float a) {
        vertexBuffer.func_227888_a_(matrix, x, y + (float)h, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + (float)w, y + (float)h, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + (float)w, y, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x, y, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public void drawMyColoredRect(float x1, float y1, float x2, float y2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexBuffer.func_225582_a_((double)x1, (double)y2, 0.0).func_181675_d();
        vertexBuffer.func_225582_a_((double)x2, (double)y2, 0.0).func_181675_d();
        vertexBuffer.func_225582_a_((double)x2, (double)y1, 0.0).func_181675_d();
        vertexBuffer.func_225582_a_((double)x1, (double)y1, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public void addColoredLineToExistingBuffer(Matrix4f matrix, IVertexBuilder vertexBuffer, float x1, float y1, float x2, float y2, float r, float g, float b, float a) {
        vertexBuffer.func_227888_a_(matrix, x1, y1, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x2, y2, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public void drawMyColoredRect(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_227888_a_(matrix, x1, y2, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x2, y2, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x2, y1, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x1, y1, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    void bindTextureBuffer(ByteBuffer image, int width, int height, int par0) {
        GlStateManager.func_227760_t_((int)par0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)image);
    }

    void putColor(byte[] bytes, int x, int y, int red, int green, int blue, int size) {
        int pixel = (y * size + x) * 3;
        bytes[pixel] = (byte)red;
        bytes[++pixel] = (byte)green;
        bytes[++pixel] = (byte)blue;
    }

    void gridOverlay(int[] result, int grid, int red, int green, int blue) {
        result[0] = (red * 3 + (grid >> 16 & 0xFF)) / 4;
        result[1] = (green * 3 + (grid >> 8 & 0xFF)) / 4;
        result[2] = (blue * 3 + (grid & 0xFF)) / 4;
    }

    void slimeOverlay(int[] result, int red, int green, int blue) {
        result[0] = (red + 82) / 2;
        result[1] = (green + 241) / 2;
        result[2] = (blue + 64) / 2;
    }

    public void defaultOrtho() {
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)512.0, (double)512.0, (double)0.0, (double)1000.0, (double)3000.0);
    }
}

