/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.Difficulty;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private ArrayList<Entity> players;
    private ArrayList<Entity> living;
    private ArrayList<Entity> livingTamed;
    private ArrayList<Entity> hostile;
    private ArrayList<Entity> items;
    private ArrayList<Entity> entities;
    private ArrayList<Entity> playersOtherTeams;
    public DataParameter<Optional<UUID>> FOX_TRUSTED_UUID_SECONDARY;
    public DataParameter<Optional<UUID>> FOX_TRUSTED_UUID_MAIN;
    private Entity lastRenderViewEntity;

    public MinimapRadar(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.players = new ArrayList();
        this.living = new ArrayList();
        this.livingTamed = new ArrayList();
        this.hostile = new ArrayList();
        this.items = new ArrayList();
        this.entities = new ArrayList();
        this.playersOtherTeams = new ArrayList();
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = FoxEntity.class.getDeclaredField("field_213509_bB");
        }
        catch (Exception e) {
            try {
                foxTrustSecondaryField = FoxEntity.class.getDeclaredField("TRUSTED_UUID_SECONDARY");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        try {
            foxTrustMainField = FoxEntity.class.getDeclaredField("field_213510_bD");
        }
        catch (Exception e) {
            try {
                foxTrustMainField = FoxEntity.class.getDeclaredField("TRUSTED_UUID_MAIN");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (foxTrustSecondaryField != null) {
            try {
                boolean accessibleBU = foxTrustSecondaryField.isAccessible();
                foxTrustSecondaryField.setAccessible(true);
                this.FOX_TRUSTED_UUID_SECONDARY = (DataParameter)foxTrustSecondaryField.get(null);
                foxTrustSecondaryField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (foxTrustMainField != null) {
            try {
                boolean accessibleBU = foxTrustMainField.isAccessible();
                foxTrustMainField.setAccessible(true);
                this.FOX_TRUSTED_UUID_MAIN = (DataParameter)foxTrustMainField.get(null);
                foxTrustMainField.setAccessible(accessibleBU);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getType(Entity e, PlayerEntity p, boolean ignoreTamed) {
        if (e instanceof PlayerEntity) {
            if (p.func_96124_cp() != ((PlayerEntity)e).func_96124_cp()) {
                return 6;
            }
            return 1;
        }
        if (!ignoreTamed && this.isTamed(e, p)) {
            return 7;
        }
        if (e.getPersistentData().func_74764_b("hostileMinimap") ? e.getPersistentData().func_74767_n("hostileMinimap") : Minecraft.func_71410_x().field_71441_e.func_175659_aa() != Difficulty.PEACEFUL && !this.hostileException(e) && (e instanceof MonsterEntity || e instanceof IMob || e.func_184176_by() == SoundCategory.HOSTILE)) {
            return 2;
        }
        if (e instanceof LivingEntity) {
            return 3;
        }
        if (e instanceof ItemEntity) {
            return 4;
        }
        return 0;
    }

    public void updateRadar(ClientWorld world, PlayerEntity p, Entity renderEntity, MinimapProcessor minimap) {
        if (renderEntity == null) {
            renderEntity = this.lastRenderViewEntity;
        }
        this.players.clear();
        this.hostile.clear();
        this.living.clear();
        this.items.clear();
        this.entities.clear();
        this.playersOtherTeams.clear();
        this.livingTamed.clear();
        if (world == null || p == null || renderEntity == null || p.func_70644_a(Effects.NO_RADAR) || p.func_70644_a(Effects.NO_RADAR_BENEFICIAL) || p.func_70644_a(Effects.NO_RADAR_HARMFUL)) {
            return;
        }
        Iterable worldEntities = world.func_217416_b();
        ModSettings settings = this.modMain.getSettings();
        int cullingSize = minimap.getMinimapSize() / 2 + 48;
        double maxDistance = (double)(cullingSize * cullingSize) / (minimap.getMinimapZoom() * minimap.getMinimapZoom());
        for (Entity e : worldEntities) {
            try {
                int type = this.getType(e, p, false);
                if (type == 1 ? e != p && !settings.getShowPlayers() : (type == 2 ? !settings.getShowHostile() : (type == 3 ? !settings.getShowMobs() : (type == 4 ? !settings.getShowItems() : (type == 6 ? !settings.getShowOtherTeam() : (type == 7 ? !settings.getShowTamedMobs() : !settings.getShowOther() || e instanceof ItemFrameEntity && !settings.itemFramesOnRadar)))))) continue;
                double offx = e.func_226277_ct_() - renderEntity.func_226277_ct_();
                double offy = e.func_226281_cx_() - renderEntity.func_226281_cx_();
                double offh = renderEntity.func_226278_cu_() - e.func_226278_cu_();
                double offheight2 = offh * offh;
                double offx2 = offx * offx;
                double offy2 = offy * offy;
                if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(settings.heightLimit * settings.heightLimit)) continue;
                ArrayList<Entity> typeList = this.entities;
                switch (type) {
                    case 1: {
                        typeList = this.players;
                        break;
                    }
                    case 2: {
                        typeList = this.hostile;
                        break;
                    }
                    case 3: {
                        typeList = this.living;
                        break;
                    }
                    case 4: {
                        typeList = this.items;
                        break;
                    }
                    case 6: {
                        typeList = this.playersOtherTeams;
                        break;
                    }
                    case 7: {
                        typeList = this.livingTamed;
                    }
                }
                if (settings.entityAmount != 0 && typeList.size() >= 100 * settings.entityAmount) continue;
                typeList.add(e);
            }
            catch (Exception ex) {}
        }
    }

    private boolean hostileException(Entity e) {
        if (e instanceof PiglinEntity) {
            return ((PiglinEntity)e).func_70631_g_();
        }
        return false;
    }

    public double getEntityX(Entity e, float partial) {
        return e.field_70142_S + (e.func_226277_ct_() - e.field_70142_S) * (double)partial;
    }

    public double getEntityY(Entity e, float partial) {
        return e.field_70137_T + (e.func_226278_cu_() - e.field_70137_T) * (double)partial;
    }

    public double getEntityZ(Entity e, float partial) {
        return e.field_70136_U + (e.func_226281_cx_() - e.field_70136_U) * (double)partial;
    }

    public boolean shouldRenderEntity(Entity e, Entity renderEntity) {
        return e == renderEntity || !e.func_225608_bj_() && !e.func_82150_aj();
    }

    public int getPlayerTeamColour(PlayerEntity p) {
        Integer teamColour = null;
        Team team = p.func_96124_cp();
        if (team != null) {
            teamColour = team.func_178775_l().func_211163_e();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public int getEntityColour(PlayerEntity p, Entity e, float offh, boolean cave, ModSettings settings) {
        int entityTeamColour;
        int type = this.getType(e, p, settings.tamedMobsColor == -1);
        if (type == 6 && settings.otherTeamColor == -1) {
            type = 1;
        }
        int color = type == 1 ? (settings.playersColor != -1 ? ModSettings.COLORS[settings.playersColor] : ((entityTeamColour = this.getPlayerTeamColour((PlayerEntity)e)) != -1 ? entityTeamColour : -1)) : (type == 2 ? ModSettings.COLORS[settings.hostileColor] : (type == 3 ? ModSettings.COLORS[settings.mobsColor] : (type == 4 ? ModSettings.COLORS[settings.itemsColor] : (type == 6 ? ModSettings.COLORS[settings.otherTeamColor] : (type == 7 ? ModSettings.COLORS[settings.tamedMobsColor] : ModSettings.COLORS[settings.otherColor])))));
        float brightness = this.getEntityBrightness(offh, settings);
        if (brightness < 1.0f) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = 255;
            if (cave) {
                a = (int)((float)a * brightness);
            } else {
                r = (int)((float)r * brightness);
                g = (int)((float)g * brightness);
                b = (int)((float)b * brightness);
            }
            color = a << 24 | r << 16 | g << 8 | b;
        }
        return color;
    }

    public float getEntityBrightness(float offh, ModSettings settings) {
        float level = (float)settings.heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        if (level <= (float)(settings.heightLimit / 2) && settings.showEntityHeight) {
            brightness = 0.25f + 0.5f * level / (float)settings.heightLimit;
        }
        return brightness;
    }

    public Iterator<Entity> getEntitiesIterator() {
        return this.entities.iterator();
    }

    public Iterator<Entity> getItemsIterator() {
        return this.items.iterator();
    }

    public Iterator<Entity> getLivingIterator() {
        return this.living.iterator();
    }

    public Iterator<Entity> getLivingTamedIterator() {
        return this.livingTamed.iterator();
    }

    public Iterator<Entity> getHostileIterator() {
        return this.hostile.iterator();
    }

    public Iterator<Entity> getPlayersIterator() {
        return this.players.iterator();
    }

    public Iterator<Entity> getPlayersOtherTeamsIterator() {
        return this.playersOtherTeams.iterator();
    }

    private boolean isTamed(Entity e, PlayerEntity p) {
        if (e instanceof TameableEntity) {
            TameableEntity tameable = (TameableEntity)e;
            if (tameable.func_70909_n() && p.func_110124_au().equals(tameable.func_184753_b())) {
                return true;
            }
        } else if (e instanceof AbstractHorseEntity) {
            AbstractHorseEntity horse = (AbstractHorseEntity)e;
            if (horse.func_110248_bS() && p.func_110124_au().equals(horse.func_184780_dh())) {
                return true;
            }
        } else if (e instanceof FoxEntity) {
            FoxEntity fox = (FoxEntity)e;
            if (this.FOX_TRUSTED_UUID_SECONDARY != null && p.func_110124_au().equals(((Optional)fox.func_184212_Q().func_187225_a(this.FOX_TRUSTED_UUID_SECONDARY)).orElse(null))) {
                return true;
            }
            if (this.FOX_TRUSTED_UUID_MAIN != null && p.func_110124_au().equals(((Optional)fox.func_184212_Q().func_187225_a(this.FOX_TRUSTED_UUID_MAIN)).orElse(null))) {
                return true;
            }
        }
        return false;
    }

    public void setLastRenderViewEntity(Entity lastRenderViewEntity) {
        this.lastRenderViewEntity = lastRenderViewEntity;
    }
}

