/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.OldAnimation;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class MinimapProcessor {
    public static final boolean DEBUG = false;
    public static final int FRAME = 9;
    private static final double log128 = Math.log(128.0);
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private MinimapWriter minimapWriter;
    private MinimapRadar entityRadar;
    private MinimapInterface minimapInterface;
    private double minimapZoom;
    private boolean toResetImage;
    private boolean enlargedMap = false;
    public final Object mainStuffSync;
    public World mainWorld;
    public double mainPlayerX;
    public double mainPlayerY;
    public double mainPlayerZ;

    public MinimapProcessor(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, MinimapWriter minimapWriter, MinimapRadar entityRadar) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.minimapWriter = minimapWriter;
        this.entityRadar = entityRadar;
        this.minimapZoom = 1.0;
        this.toResetImage = true;
        this.mainStuffSync = new Object();
        this.minimapInterface = modMain.getInterfaces().getMinimapInterface();
    }

    public int getMinimapSize() {
        return this.enlargedMap ? 500 : this.modMain.getSettings().getMinimapSize() * 2;
    }

    public int getMinimapBufferSize(int minimapSize) {
        double diagonal = Math.sqrt(2.0) * (double)minimapSize;
        int bufferSize = (int)Math.pow(128.0, Math.ceil(Math.log(diagonal) / log128));
        if (bufferSize > 512) {
            return 512;
        }
        return bufferSize;
    }

    public boolean isEnlargedMap() {
        return this.enlargedMap;
    }

    public void setEnlargedMap(boolean enlargedMap) {
        this.enlargedMap = enlargedMap;
    }

    public double getMinimapZoom() {
        return this.minimapZoom;
    }

    private double getTargetZoom() {
        float target;
        float settingsZoom = this.modMain.getSettings().zooms[this.modMain.getSettings().zoom];
        if (this.enlargedMap && this.modMain.getSettings().zoomedOutEnlarged) {
            settingsZoom = 1.0f;
        }
        if ((target = settingsZoom * (this.modMain.getSettings().caveZoom > 0 && this.minimapWriter.getLoadedCaving() != -1 ? (float)(1 + this.modMain.getSettings().caveZoom) : 1.0f)) > this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1]) {
            target = this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1];
        }
        return target;
    }

    public void instantZoom() {
        this.minimapZoom = this.getTargetZoom();
    }

    public void updateZoom() {
        double target = this.getTargetZoom();
        double off = target - this.minimapZoom;
        off = off > 0.01 || off < -0.01 ? (double)((float)OldAnimation.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public MinimapWriter getMinimapWriter() {
        return this.minimapWriter;
    }

    public boolean canUseFrameBuffer() {
        return !(!GL.getCapabilities().OpenGL14 || !GL.getCapabilities().GL_ARB_framebuffer_object && !GL.getCapabilities().GL_EXT_framebuffer_object && !GL.getCapabilities().OpenGL30 || !GL.getCapabilities().OpenGL15 && !GL.getCapabilities().GL_ARB_vertex_buffer_object || !GL.getCapabilities().OpenGL21 && !GL.getCapabilities().GL_EXT_pixel_buffer_object && !GL.getCapabilities().GL_ARB_pixel_buffer_object);
    }

    public int getFBOBufferSize() {
        return 512;
    }

    public void onClientTick() {
        World world = null;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p instanceof ClientWorld) {
            world = player.field_70170_p;
        }
        if (this.modMain.getSettings().getMinimap()) {
            this.entityRadar.updateRadar((ClientWorld)world, (PlayerEntity)player, Minecraft.func_71410_x().func_175606_aa(), this);
        }
    }

    public void onPlayerTick() {
        if (this.minimapSession.getWaypointsManager().getCurrentContainerID() != null && this.minimapSession.getWaypointsManager().getCurrentWorldID() != null) {
            this.minimapWriter.setSeedForLoading(this.modMain.getSettings().getSlimeChunksSeed(this.minimapSession.getWaypointsManager().getCurrentContainerAndWorldID()));
        }
    }

    public void onRender(MatrixStack matrixStack, int x, int y, int width, int height, double scale, int size, int boxSize, float partial, CustomVertexConsumers cvc) {
        try {
            if (this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() && !this.canUseFrameBuffer()) {
                this.minimapInterface.getMinimapFBORenderer().setLoadedFBO(false);
                this.minimapInterface.getMinimapFBORenderer().deleteFramebuffers();
                this.toResetImage = true;
            }
            if (!(this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() || this.modMain.getSettings().mapSafeMode || this.minimapInterface.getMinimapFBORenderer().isTriedFBO())) {
                this.minimapInterface.getMinimapFBORenderer().loadFrameBuffer(this);
            }
            if (this.enlargedMap && this.modMain.getSettings().centeredEnlarged) {
                x = (width - boxSize) / 2;
                y = (height - boxSize) / 2;
            }
            if (this.minimapInterface.usingFBO()) {
                this.minimapInterface.getMinimapFBORenderer().renderMinimap(this.minimapSession, matrixStack, this, x, y, width, height, scale, size, partial, cvc);
            } else {
                this.minimapInterface.getMinimapSafeModeRenderer().renderMinimap(this.minimapSession, matrixStack, this, x, y, width, height, scale, size, partial, cvc);
            }
        }
        catch (Throwable e) {
            this.minimapInterface.setCrashedWith(e);
            this.minimapInterface.checkCrashes();
        }
    }

    public static boolean hasMinimapItem(PlayerEntity player) {
        return Misc.hasItem(player, ModSettings.minimapItem);
    }

    public boolean isToResetImage() {
        return this.toResetImage;
    }

    public void setToResetImage(boolean toResetImage) {
        this.toResetImage = toResetImage;
    }

    public MinimapRadar getEntityRadar() {
        return this.entityRadar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainValues() {
        Object object = this.mainStuffSync;
        synchronized (object) {
            Entity player = Minecraft.func_71410_x().func_175606_aa();
            if (player != null) {
                this.mainWorld = player.field_70170_p;
                this.mainPlayerX = player.func_226277_ct_();
                this.mainPlayerY = player.func_226278_cu_();
                this.mainPlayerZ = player.func_226281_cx_();
            } else {
                this.mainWorld = null;
            }
        }
    }

    public void cleanup() {
        this.minimapWriter.cleanup();
    }
}

