/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.core.IXaeroMinimapSMultiBlockChangePacket;
import xaero.common.interfaces.pushbox.IBossHealthPushBox;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.misc.Misc;
import xaero.patreon.Patreon6;

public class XaeroMinimapCore {
    public static IXaeroMinimap modMain;
    public static Field chunkCleanField;
    public static XaeroMinimapSession currentSession;
    private static Matrix4f waypointsProjection;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = Chunk.class.getDeclaredField("xaero_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroMinimapCore.ensureField();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        Chunk chunk = world.func_212866_a_(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(SChunkDataPacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_149273_e(), packetIn.func_149271_f());
    }

    public static void onBlockChange(SChangeBlockPacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_179827_b().func_177958_n() >> 4, packetIn.func_179827_b().func_177952_p() >> 4);
    }

    public static void onMultiBlockChange(SMultiBlockChangePacket packetIn) {
        IXaeroMinimapSMultiBlockChangePacket packetAccess = (IXaeroMinimapSMultiBlockChangePacket)packetIn;
        XaeroMinimapCore.chunkUpdateCallback(packetAccess.xaero_mm_getSectionPos().func_177958_n(), packetAccess.xaero_mm_getSectionPos().func_177952_p());
    }

    public static void onSpawn(SWorldSpawnChangedPacket packetIn) {
        modMain.getEvents().handlePlayerSetSpawn((World)Minecraft.func_71410_x().field_71441_e, packetIn.func_240832_b_());
    }

    public static ResourceLocation getPlayerCape(AbstractClientPlayerEntity player) {
        if (XaeroMinimapCore.modMain.getSupportMods().optifine) {
            return null;
        }
        return Patreon6.getPlayerCape(modMain.getFileLayoutID(), player);
    }

    public static Boolean isWearing(PlayerEntity player, PlayerModelPart part) {
        if (XaeroMinimapCore.modMain.getSupportMods().optifine) {
            return null;
        }
        if (part != PlayerModelPart.CAPE || !(player instanceof AbstractClientPlayerEntity)) {
            return null;
        }
        return Patreon6.isWearingCape(modMain.getFileLayoutID(), (AbstractClientPlayerEntity)player);
    }

    public static void onPlayNetHandler(ClientPlayNetHandler netHandler) {
        try {
            XaeroMinimapSession minimapSession;
            IXaeroMinimapClientPlayNetHandler netHandlerAccess = (IXaeroMinimapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_minimapSession() != null) {
                return;
            }
            if (currentSession != null) {
                System.out.println("Previous minimap session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroMinimapCore.cleanupCurrentSession();
            }
            currentSession = minimapSession = modMain.createSession();
            minimapSession.init();
            netHandlerAccess.setXaero_minimapSession(minimapSession);
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroMinimapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
            Minecraft.func_71410_x().field_71441_e.func_72882_A();
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.cleanup();
        }
        catch (Throwable supressed) {
            supressed.printStackTrace();
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(ClientPlayNetHandler netHandler) {
        try {
            XaeroMinimapSession netHandlerSession = ((IXaeroMinimapClientPlayNetHandler)netHandler).getXaero_minimapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.cleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IXaeroMinimapClientPlayNetHandler)netHandler).setXaero_minimapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    public static void beforeRespawn(PlayerEntity player) {
        if (player == Minecraft.func_71410_x().field_71439_g) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().createDeathpoint(player);
        }
    }

    public static void onProjectionMatrix(Matrix4f matrixIn) {
        waypointsProjection.set(matrixIn);
    }

    public static void beforeIngameGuiRender(float partialTicks) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null && Minecraft.func_71410_x().field_71441_e == minimapSession.getMinimapProcessor().mainWorld) {
            MainWindow mainwindow = Minecraft.func_71410_x().func_228018_at_();
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)mainwindow.func_198109_k(), (double)mainwindow.func_198091_l(), (double)0.0, (double)1000.0, (double)3000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            modMain.getInterfaces().getMinimapInterface().getWaypointsIngameRenderer().render(minimapSession, partialTicks, minimapSession.getMinimapProcessor(), waypointsProjection);
            RenderSystem.matrixMode((int)5889);
            Misc.minecraftOrtho(Minecraft.func_71410_x());
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
        }
    }

    public static void onBossHealthRender(int h) {
        IBossHealthPushBox bossHealthPushBox = modMain.getInterfaces().getBossHealthPushBox();
        if (bossHealthPushBox != null) {
            bossHealthPushBox.setActive(true);
            bossHealthPushBox.setLastBossHealthHeight(h);
        }
    }

    public static void onEntityIconsModelRenderDetection(EntityModel<?> model, float red, float green, float blue, float alpha) {
        if (!EntityIconPrerenderer.DETECTING_MODEL_RENDERS) {
            return;
        }
        modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().onEntityIconsModelRenderDetection(model, red, green, blue, alpha);
    }

    public static void onEntityIconsModelPartRenderDetection(ModelRenderer modelRenderer, float red, float green, float blue, float alpha) {
        if (!EntityIconPrerenderer.DETECTING_MODEL_RENDERS) {
            return;
        }
        modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().onEntityIconsModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }

    static {
        chunkCleanField = null;
        waypointsProjection = new Matrix4f();
    }
}

