/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class WizardStaffItemHandler
extends ItemStackHandler {
    public static final int SLOT_COUNT = 3;
    private boolean isVisible = true;
    private ItemStack staff;
    private int current;

    public WizardStaffItemHandler(ItemStack staff) {
        super(3);
        this.staff = staff;
    }

    public void cycleCurrent() {
        int start = this.current;
        do {
            this.current = (this.current + 1) % 3;
        } while (this.getCurrent().func_190926_b() && this.current != start);
    }

    public ItemStack extractCurrent() {
        return this.extractItem(this.current, 1, false);
    }

    public ItemStack insertCurrent(ItemStack insert) {
        return this.insertItem(this.current, insert, false);
    }

    public ItemStack getCurrent() {
        return this.getStackInSlot(this.current);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a("current", this.current);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("current")) {
            this.current = nbt.func_74762_e("current");
        }
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    protected void onContentsChanged(int slot) {
        CompoundNBT nbt;
        nbt.func_74757_a("wizard-staff-dirty", !(nbt = this.staff.func_196082_o()).func_74767_n("wizard-staff-dirty"));
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public static WizardStaffItemHandler orNull(ItemStack staff) {
        return (WizardStaffItemHandler)((Object)staff.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null));
    }

    public static LazyOptional<WizardStaffItemHandler> getOptional(ItemStack staff) {
        IItemHandler handler;
        LazyOptional itemHandlerOpt = staff.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (itemHandlerOpt.isPresent() && (handler = (IItemHandler)itemHandlerOpt.orElse(null)) instanceof WizardStaffItemHandler) {
            return LazyOptional.of(() -> (WizardStaffItemHandler)handler);
        }
        return LazyOptional.empty();
    }

    public static WizardStaffItemHandler get(ItemStack staff) {
        IItemHandler handler = (IItemHandler)staff.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("ItemStack is missing wizard staff capability"));
        return (WizardStaffItemHandler)handler;
    }
}

