/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WizardStaffCapabilityProvider
implements ICapabilitySerializable<INBT> {
    private ItemStack staff;
    private LazyOptional<IItemHandler> instance = LazyOptional.of(this::getHandler);
    private WizardStaffItemHandler handler;

    public WizardStaffCapabilityProvider(ItemStack staff) {
        this.staff = staff;
    }

    private WizardStaffItemHandler getHandler() {
        if (this.handler == null) {
            this.handler = new WizardStaffItemHandler(this.staff);
        }
        return this.handler;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.instance);
    }

    public INBT serializeNBT() {
        return this.getHandler().serializeNBT();
    }

    public void deserializeNBT(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            this.getHandler().deserializeNBT((CompoundNBT)nbt);
        } else if (nbt instanceof ListNBT) {
            this.legacyDeserialize((ListNBT)nbt);
        }
    }

    private void legacyDeserialize(ListNBT nbt) {
        if (nbt.size() < 1) {
            return;
        }
        CompoundNBT compound = nbt.func_150305_b(0);
        this.getHandler().insertItem(0, ItemStack.func_199557_a((CompoundNBT)compound), false);
    }
}

