/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.staff;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.Magics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class SpellbookGui
extends AbstractGui
implements IRenderable,
IGuiEventListener {
    private static final ITextComponent SEARCH_HINT = new TranslationTextComponent("gui.wizard-staff.search_hint").func_240699_a_(TextFormatting.ITALIC);
    private static final ResourceLocation GUI = new ResourceLocation("wizard-staff", "textures/gui/spellbook.png");
    private static final int X_OFFSET = 86;
    private static final int X_SIZE = 147;
    private static final int Y_SIZE = 166;
    private static final int BORDER_X = 16;
    private static final int BORDER_Y = 12;
    private static final int ITEM_BORDER_Y = 24;
    private static final int ITEM_SIZE = 20;
    private static final int ITEMS_PER_ROW = 6;
    private static final int ITEMS_PER_COLUMN = 6;
    private static final int ITEMS_PER_PAGE = 36;
    private static final int BUTTON_SIZE = 20;
    private static final int BUTTON_BOTTOM_OFFSET = 26;
    private static final int SEARCH_WIDTH = 107;
    private static final int SEARCH_HEIGHT = 14;
    private boolean isActive;
    private int left;
    private int top;
    private int width;
    private int height;
    private List<ItemButton> buttons;
    private List<ItemButton> searched;
    private Button next;
    private Button prev;
    private int page;
    private SpellDescription description;
    private TextFieldWidget search;
    private static final TranslationTextComponent COST = new TranslationTextComponent("gui.wizard-staff.cost");
    private static final TranslationTextComponent EXP = new TranslationTextComponent("gui.wizard-staff.exp");
    private static final TranslationTextComponent DURATION = new TranslationTextComponent("gui.wizard-staff.duration");
    private static final TranslationTextComponent INFINITY = new TranslationTextComponent("gui.wizard-staff.infinity");
    private static final TranslationTextComponent SECONDS = new TranslationTextComponent("gui.wizard-staff.seconds");

    public void init(int width, int height) {
        this.width = width;
        this.height = height;
        this.left = (width - 147) / 2 - 86;
        this.top = (height - 166) / 2;
        this.buttons = new ArrayList<ItemButton>();
        this.searched = new ArrayList<ItemButton>();
        int i = 0;
        for (ItemStack stack : Magics.getInstance(true).getMagicItems()) {
            this.buttons.add(new ItemButton(this.left + 16 + i % 6 * 20, this.top + 24 + i / 6 * 20, 20, 20, stack));
            i = (i + 1) % 36;
        }
        this.next = new ImageButton(this.left + 73 + 20, this.top + 166 - 26, 20, 20, 0, 166, 20, GUI, b -> {
            if ((this.page + 1) * 36 < this.searched.size()) {
                ++this.page;
            }
        });
        this.prev = new ImageButton(this.left + 73 - 20 - 20, this.top + 166 - 26, 20, 20, 20, 166, 20, GUI, b -> {
            if (this.page > 0) {
                --this.page;
            }
        });
        this.initSearch();
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        if (this.description != null) {
            this.description.init(this.left, this.top);
        }
    }

    private void initSearch() {
        String text = this.search == null ? "" : this.search.func_146179_b();
        this.search = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.left + 26, this.top + 13, 107, 14, SEARCH_HINT);
        this.search.func_146203_f(50);
        this.search.func_146180_a(text);
        this.search.func_146185_a(false);
        this.search.func_146189_e(true);
        this.search.func_146193_g(-1);
        this.filterButtons();
    }

    public void tick() {
        this.search.func_146178_a();
    }

    public void onClose() {
        this.search = null;
        Minecraft.func_71410_x().field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.isActive) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(GUI);
        this.func_238474_b_(matrixStack, this.left, this.top, 0, 0, 147, 166);
        if (this.description == null) {
            for (int i = this.page * 36; i < Math.min(this.searched.size(), (this.page + 1) * 36); ++i) {
                this.searched.get(i).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
            this.next.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.prev.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            SpellbookGui.func_238464_a_((MatrixStack)matrixStack, (int)(this.left + 12), (int)(this.top + 8), (int)0, (float)0.0f, (float)206.0f, (int)16, (int)16, (int)256, (int)256);
            if (!this.search.func_230999_j_() && this.search.func_146179_b().isEmpty()) {
                SpellbookGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (ITextComponent)SEARCH_HINT, (int)(this.left + 26), (int)(this.top + 13), (int)-1);
            } else {
                this.search.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
            String pageText = this.page + 1 + "/" + (this.searched.size() / 36 + 1);
            int textWidth = mc.field_71466_p.func_78256_a(pageText);
            mc.field_71466_p.func_238421_b_(matrixStack, pageText, (float)(this.left + 73) - (float)textWidth / 2.0f, (float)(this.top + 166 - 22), -1);
        } else {
            this.description.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (!this.isActive) {
            return false;
        }
        if (this.description == null) {
            for (int i = this.page * 36; i < Math.min(this.searched.size(), (this.page + 1) * 36); ++i) {
                if (!this.searched.get(i).func_231044_a_(mouseX, mouseY, button)) continue;
                return true;
            }
            if (this.search.func_231044_a_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.next.func_231044_a_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.prev.func_231044_a_(mouseX, mouseY, button)) {
                return true;
            }
        } else if (this.description.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.description == null) {
            if (this.search.func_231046_a_(keyCode, scanCode, modifiers)) {
                this.filterButtons();
                return true;
            }
            if (this.search.func_230999_j_() && keyCode != 256) {
                return true;
            }
        }
        return false;
    }

    private void filterButtons() {
        String filter = this.search.func_146179_b().toLowerCase();
        this.searched = new ArrayList<ItemButton>();
        int i = 0;
        for (ItemButton b : this.buttons) {
            if (!b.stack.func_200301_q().getString().toLowerCase().contains(filter) && !b.magicDescr.getName().getString().toLowerCase().contains(filter)) continue;
            this.searched.add(b);
            b.field_230690_l_ = this.left + 16 + i % 6 * 20;
            b.field_230691_m_ = this.top + 24 + i / 6 * 20;
            i = (i + 1) % 36;
        }
        this.page = 0;
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.description == null && this.search.func_231042_a_(codePoint, modifiers)) {
            this.filterButtons();
            return true;
        }
        return false;
    }

    public void toggleActive() {
        this.isActive = !this.isActive;
    }

    public int updatePosition(int width, int sizeX) {
        if (this.isActive) {
            return 86 + (width - sizeX) / 2;
        }
        return (width - sizeX) / 2;
    }

    private class SpellDescription
    implements IRenderable,
    IGuiEventListener {
        private ItemStack stack;
        private Button back;
        private int left;
        private Button next;
        private Button prev;
        private int top;
        private Magic.Description magicDescr;
        private int page;
        List<IReorderingProcessor> title;
        List<IReorderingProcessor> text;
        String cost;
        String duration;
        private int linesPerPage;
        private int pageCount;

        public SpellDescription(Magic.Description magicDescr, ItemStack stack, int left, int top) {
            this.magicDescr = magicDescr;
            this.stack = stack;
            this.init(left, top);
        }

        public void init(int left, int top) {
            this.left = left;
            this.top = top;
            this.back = new ImageButton(left + 16, top + 12, 20, 20, 20, 166, 20, GUI, b -> SpellbookGui.this.description = null);
            this.next = new ImageButton(left + 73 + 20, top + 166 - 26, 20, 20, 0, 166, 20, GUI, b -> {
                if (this.page < this.pageCount - 1) {
                    ++this.page;
                }
            });
            this.prev = new ImageButton(left + 73 - 20 - 20, top + 166 - 26, 20, 20, 20, 166, 20, GUI, b -> {
                if (this.page > 0) {
                    --this.page;
                }
            });
            this.title = Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)this.magicDescr.getName(), 115);
            this.text = Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)this.magicDescr.getDescription(), 115);
            this.linesPerPage = 7 - this.title.size();
            this.pageCount = (int)Math.ceil((float)this.text.size() / (float)this.linesPerPage);
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            this.cost = COST.getString() + ": " + decimalFormat.format(this.magicDescr.getCost()) + " " + EXP.getString();
            float durationSeconds = (float)this.magicDescr.getDuration() / 20.0f;
            String durationTime = this.magicDescr.getDuration() >= 72000 ? INFINITY.getString() : decimalFormat.format(durationSeconds);
            this.duration = DURATION.getString() + ": " + durationTime + " " + SECONDS.getString();
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.back.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.pageCount > 1) {
                this.next.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                this.prev.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
            Minecraft mc = Minecraft.func_71410_x();
            int y = this.top + 12;
            int textWidth = 0;
            mc.func_175599_af().func_180450_b(this.stack, this.left + 73 - 8, y);
            y += 20;
            for (IReorderingProcessor line : this.title) {
                textWidth = mc.field_71466_p.func_243245_a(line);
                mc.field_71466_p.func_238422_b_(matrixStack, line, (float)(this.left + 73) - (float)textWidth / 2.0f, (float)y, -1);
                mc.field_71466_p.getClass();
                y += 9;
            }
            mc.field_71466_p.func_238421_b_(matrixStack, this.cost, (float)(this.left + 16), (float)(y += 10), -1);
            mc.field_71466_p.func_238421_b_(matrixStack, this.duration, (float)(this.left + 16), (float)(y += 10), -1);
            y += 20;
            for (int i = this.page * this.linesPerPage; i < Math.min(this.page * this.linesPerPage + this.linesPerPage, this.text.size()); ++i) {
                mc.field_71466_p.func_238422_b_(matrixStack, this.text.get(i), (float)(this.left + 16), (float)y, -1);
                mc.field_71466_p.getClass();
                y += 9;
            }
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.back.func_231044_a_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.pageCount > 1 && this.next.func_231044_a_(mouseX, mouseY, button)) {
                return true;
            }
            return this.pageCount > 1 && this.prev.func_231044_a_(mouseX, mouseY, button);
        }
    }

    private class ItemButton
    extends AbstractButton {
        private ItemStack stack;
        private Magic.Description magicDescr;

        public ItemButton(int x, int y, int width, int height, ItemStack stack) {
            super(x, y, width, height, stack.func_200301_q());
            this.stack = stack;
            this.magicDescr = Magics.getInstance(true).get(stack).getDescription();
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (this.func_230449_g_()) {
                GuiUtils.drawHoveringText((MatrixStack)matrixStack, Arrays.asList(this.func_230458_i_()), (int)mouseX, (int)mouseY, (int)SpellbookGui.this.width, (int)SpellbookGui.this.height, (int)-1, (FontRenderer)minecraft.field_71466_p);
            }
            minecraft.func_175599_af().func_180450_b(this.stack, this.field_230690_l_, this.field_230691_m_);
        }

        public void func_230930_b_() {
            SpellbookGui.this.description = new SpellDescription(this.magicDescr, this.stack, SpellbookGui.this.left, SpellbookGui.this.top);
        }
    }
}

