/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.network;

import java.util.UUID;
import java.util.function.Supplier;
import mod.vemerion.wizardstaff.sound.WizardStaffTickableSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class JukeboxMagicMessage {
    private UUID id;
    private SoundEvent music;

    public JukeboxMagicMessage(UUID id, SoundEvent music) {
        this.id = id;
        this.music = music;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.id);
        buffer.writeRegistryId((IForgeRegistryEntry)this.music);
    }

    public static JukeboxMagicMessage decode(PacketBuffer buffer) {
        return new JukeboxMagicMessage(buffer.func_179253_g(), (SoundEvent)buffer.readRegistryId());
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> PlayMusic.play(this.id, this.music)));
    }

    private static class PlayMusic {
        private PlayMusic() {
        }

        private static DistExecutor.SafeRunnable play(final UUID id, final SoundEvent music) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    WizardStaffTickableSound sound = new WizardStaffTickableSound(id, music);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                }
            };
        }
    }
}

