/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.entity;

import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.init.ModParticles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkHooks;

public class NetherPortalEntity
extends Entity {
    private static final int MAX_DURATION = 600;
    private int duration;

    public NetherPortalEntity(EntityType<? extends NetherPortalEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.spawnParticles();
            if (this.duration++ > 600) {
                this.func_70106_y();
            }
        }
    }

    private void spawnParticles() {
        ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
        Vector3d sideways = Vector3d.func_189986_a((float)0.0f, (float)(this.field_70177_z + 90.0f));
        for (int j = 0; j < 30; ++j) {
            float rotation = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
            float offset = this.field_70146_Z.nextFloat() * 0.05f - 0.025f;
            Vector3d pos = this.func_213303_ch().func_72441_c(sideways.field_72450_a * (double)MathHelper.func_76134_b((float)rotation) * (0.5 + (double)offset), (double)(1.0f + MathHelper.func_76126_a((float)rotation) * (1.0f + offset)), sideways.field_72449_c * (double)MathHelper.func_76134_b((float)rotation) * (0.5 + (double)offset));
            serverWorld.func_195598_a((IParticleData)ModParticles.MAGIC_SMOKE_PARTICLE, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K && this.duration > 20) {
            World world = player.field_70170_p;
            player.func_242279_ag();
            ServerWorld nether = ((ServerWorld)world).func_73046_m().func_71218_a(World.field_234919_h_);
            if (nether != null) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)player, (Object)player.func_233580_cy_().func_185334_h(), (String)"field_242271_ac");
                    player.func_241206_a_(nether);
                }
                catch (RuntimeException e) {
                    Main.LOGGER.warn("Unable to use spell to teleport to nether, reason: " + e);
                }
            }
        }
        return ActionResultType.FAIL;
    }

    public float func_70013_c() {
        return 15.0f;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

