/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.entity;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.UUID;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.entity.ICasted;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MagicVexEntity
extends VexEntity
implements ICasted {
    private static Field goals;
    private UUID caster;

    public MagicVexEntity(EntityType<? extends MagicVexEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 0;
    }

    @Override
    public UUID getCasterUUID() {
        return this.caster;
    }

    @Override
    public void setCasterUUID(UUID id) {
        this.caster = id;
    }

    protected boolean func_225511_J_() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        PlayerEntity caster = this.getCaster(this.field_70170_p);
        float damage = (float)this.func_233637_b_(Attributes.field_233823_f_);
        DamageSource source = caster == null ? Magic.magicDamage() : Magic.magicDamage((Entity)this, caster);
        return entityIn.func_70097_a(source, damage);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new UpdateOrigin(this));
        this.clearTargetSelector();
        this.field_70715_bh.func_75776_a(0, (Goal)new CopyCasterTargetGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new DefendCasterGoal(this));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("shooter")) {
            this.loadCaster(compound.func_74775_l("shooter"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("shooter", (INBT)this.saveCaster());
    }

    private void clearTargetSelector() {
        if (goals == null) {
            goals = ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"field_220892_d");
        }
        try {
            ((Set)goals.get(this.field_70715_bh)).clear();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Main.LOGGER.warn("Failed to clear targetSelector: " + e.getMessage());
        }
    }

    public static class UpdateOrigin
    extends Goal {
        private MagicVexEntity vex;

        public UpdateOrigin(MagicVexEntity vex) {
            this.vex = vex;
        }

        public boolean func_75250_a() {
            PlayerEntity player = this.vex.getCaster(this.vex.field_70170_p);
            if (player == null) {
                return false;
            }
            return this.vex.func_70681_au().nextInt(30) == 1 && player.func_70068_e((Entity)this.vex) < 2000.0;
        }

        public void func_75249_e() {
            PlayerEntity player = this.vex.getCaster(this.vex.field_70170_p);
            if (player == null) {
                return;
            }
            this.vex.func_190651_g(player.func_233580_cy_());
        }
    }

    private static class DefendCasterGoal
    extends SetAttackTargetGoal {
        public DefendCasterGoal(MagicVexEntity vex) {
            super(vex);
        }

        @Override
        protected LivingEntity getTarget(PlayerEntity player) {
            return player.func_70643_av();
        }

        @Override
        protected int getTimestamp(PlayerEntity player) {
            return player.func_142015_aE();
        }
    }

    private static class CopyCasterTargetGoal
    extends SetAttackTargetGoal {
        public CopyCasterTargetGoal(MagicVexEntity vex) {
            super(vex);
        }

        @Override
        protected LivingEntity getTarget(PlayerEntity player) {
            return player.func_110144_aD();
        }

        @Override
        protected int getTimestamp(PlayerEntity player) {
            return player.func_142013_aG();
        }
    }

    private static abstract class SetAttackTargetGoal
    extends TargetGoal {
        private MagicVexEntity vex;
        private int timestamp;

        public SetAttackTargetGoal(MagicVexEntity vex) {
            super((MobEntity)vex, false);
            this.vex = vex;
        }

        public boolean func_75250_a() {
            PlayerEntity player = this.vex.getCaster(this.vex.field_70170_p);
            if (player == null) {
                return false;
            }
            if (this.timestamp == this.getTimestamp(player)) {
                return false;
            }
            LivingEntity target = this.getTarget(player);
            return target != null && (!(target instanceof MagicVexEntity) || ((MagicVexEntity)target).getCaster(this.vex.field_70170_p) != player);
        }

        public void func_75249_e() {
            PlayerEntity player = this.vex.getCaster(this.vex.field_70170_p);
            if (player == null) {
                return;
            }
            this.vex.func_70624_b(this.getTarget(player));
            this.timestamp = this.getTimestamp(player);
            super.func_75249_e();
        }

        protected abstract LivingEntity getTarget(PlayerEntity var1);

        protected abstract int getTimestamp(PlayerEntity var1);
    }
}

